﻿---
title: Manage case settings in Kibana
description: To change case closure options and add custom fields, templates, and connectors for external incident management systems, go to Stack Management > Cases...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/manage-cases-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Manage case settings in Kibana
To change case closure options and add custom fields, templates, and connectors for external incident management systems, go to **Stack Management > Cases** and click **Settings**.
To perform these tasks, you must have [full access](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases) to the appropriate case and connector features in Kibana.
![View case settings](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-settings.png)


## Case closures

If you close cases in your external incident management system, they will remain open in **Cases** until you close them manually.
To change whether cases are automatically closed after they are sent to an external system, update the case closure options.

## External incident management systems

You can add connectors to cases to push information to these external incident management systems:
- IBM Resilient
- Jira
- ServiceNow ITSM
- ServiceNow SecOps
- Swimlane
- TheHive
- Webhook - Case Management

<note>
  To create connectors and send cases to external systems, you must have the appropriate Kibana feature privileges. Refer to [Configure access to cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases).
</note>

You can create connectors in **Stack Management > Connectors**, as described in [*Connectors*](https://www.elastic.co/docs/deploy-manage/manage-connectors). Alternatively, you can create them in **Stack Management > Cases > Settings**:
1. From the **Incident management system** list, select **Add new connector**.
2. Select an external incident management system.
3. Enter your required settings. Refer to [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type), [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type), [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), [TheHive](https://www.elastic.co/docs/reference/kibana/connectors-kibana/thehive-action-type), or [Webhook - Case Management](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type) for connector configuration details.

You can subsequently choose the connector when you create cases and use it in case templates. To change the default connector for new cases, select the connector from the **Incident management system** list.
To update a connector, click **Update <connector name>** and edit the connector fields as required.

## Custom fields

<admonition title="Added in 8.15.0">
  This functionality was added in 8.15.0.
</admonition>

You can add optional and required fields for customized case collaboration.
To create a custom field:
1. In the **Custom fields** section, click **Add field**.
   ![Add a custom field in case settings](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-custom-fields-add.png)
2. You must provide a field label and type (text or toggle). You can optionally designate it as a required field and provide a default value.

When you create a custom field, it’s added to all new and existing cases. Existing cases have null values for new text fields until you set them in each case.
You can subsequently remove or edit custom fields on the **Settings** page.

## Templates

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

You can make the case creation process faster and more consistent by adding templates. A template defines values for one or all of the case fields (such as severity, tags, description, and title) as well as any custom fields.
To create a template:
1. In the **Templates** section, click **Add template**.
   ![Add a template in case settings](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-templates-add.png)
2. You must provide a template name and case severity. You can optionally add template tags and a description, values for each case field, and a case connector.

When users create cases, they can optionally select a template and use its values or override them.
<note>
  If you update or delete templates, existing cases are unaffected.
</note>