﻿---
title: Cases in Kibana
description: Cases are used to open and track issues directly in Kibana. You can add assignees and tags to your cases, set their severity and status, and add alerts,...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/cases
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Cases in Kibana
Cases are used to open and track issues directly in Kibana. You can add assignees and tags to your cases, set their severity and status, and add alerts, comments, and visualizations. You can create cases automatically when alerts occur or send cases to external incident management systems by configuring connectors.
<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> You can also optionally add custom fields and case templates.
<applies-to>Elastic Stack: Generally available since 9.2</applies-to> Cases are automatically assigned human-readable numeric IDs, which you can use for easier referencing. Each time you create a new case in your [space](https://www.elastic.co/docs/deploy-manage/manage-spaces), the case ID increments by one. IDs are assigned to cases by a background task that runs every 10 minutes, which can cause a delay in ID assignment, especially in spaces with many cases. You can find the case ID after the case's name and can use it while searching the Cases table.
![Cases page](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-list.png)

<note>
  If you create cases in the Observability or Elastic Security app, they are not visible in **Stack Management**. Likewise, the cases you create in **Stack Management** are not visible in the Observability or Elastic Security app. You also cannot attach alerts from the Observability or Elastic Security app to cases in **Stack Management**.
</note>

- [Configure access to cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases)
- [Open and manage cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/manage-cases)
- [Configure case settings](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/manage-cases-settings)
- <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Unavailable</applies-to>[Use cases as data](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/cases-as-data)


## Limitations

- If you create cases in Stack Management, they are not visible from Observability or the Elastic Security app. Likewise, the cases you create in Observability are not visible in Stack Management or Elastic Security.
- You cannot attach alerts from Observability or Elastic Security to cases in Stack Management.