﻿---
title: View and manage alerts in Kibana
description: When the conditions of a rule are met, it creates an alert. If the rule has actions, they run at the defined frequency. For example, the rule can send...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/view-alerts
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# View and manage alerts in Kibana
When the conditions of a rule are met, it creates an alert. If the rule has actions, they run at the defined frequency. For example, the rule can send email notifications for each alert at a custom interval. For an introduction to the concepts of rules, alerts, and actions, refer to [Alerting](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts).
Manage alerts from the following places:
- **Rule details page**: On a rule's details page, alerts the rule generates appear in the Alerts table. To access a rule's details page, find the **Rules** management page in the navigation menu or using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) (**Alerts and Insights > Rules**), then click its name.
- **Alerts management page**: Alerts generated by Stack Management rules appear on the **Alerts** management page. Accessing this page differs based on the [navigation view](/docs/deploy-manage/manage-spaces#spaces-managing) that you're using:
  - **Classic navigation**: Find the **Alerts** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) (**Stack Management > Alerts**).
- **Solution navigation**: Use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) (**Alerts and Insights > Alerts**).

![Alerts page with multiple alerts](https://www.elastic.co/docs/explore-analyze/images/kibana-stack-management-alerts-page.png)

<note>
  You must have the appropriate Kibana alerting features and index privileges to view alerts. Refer to [Alerting security requirements](/docs/explore-analyze/alerts-cases/alerts/alerting-setup#alerting-security).
</note>


## Filter alerts

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

In **Stack Management** > **Alerts**, you can filter the list (for example, by alert status or rule type) and customize the filter controls. To search for specific alerts, use the KQL bar to create structured queries using [Kibana Query Language](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql).
By default, the list contains all the alerts that you have authority to view in the selected time period except those associated with Security rules. To view alerts for Security rules, click the query menu and select **Security rule types**:
![The Alerts page with the query menu open](https://www.elastic.co/docs/explore-analyze/images/kibana-stack-management-alerts-query-menu.png)

Alternatively, view those alerts in the [Elastic Security app](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts).

## View alert details

To get more information about a specific alert, click the action menu icon `boxes_vertical` and select **View alert details** in either **Stack Management > Alerts** or **Rules**. There you’ll see the current status of the alert, its duration, and when it was last updated. To help you determine what caused the alert, there is information such as the expected and actual threshold values and a summarized reason for the alert.
If an alert is affected by a maintenance window, the alert details include its identifier. For more information about their impact on alert notifications, refer to [Maintenance windows](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows).

## Alert statuses

There are four common alert statuses:
<definitions>
  <definition term="active">
    The conditions for the rule are met. If the rule has [actions](/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-actions-details), Kibana generates notifications based on the actions' notification settings.
  </definition>
  <definition term="flapping">
    The alert switched repeatedly between active and recovered states. If actions are configured to run when its status changes, they are suppressed. Refer to [Alert flapping](/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-flapping-details) to learn more about configuring alert flapping for rules.
  </definition>
  <definition term="recovered">
    The conditions for the rule are no longer met. If the rule has [recovery actions](/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-actions-details), Kibana generates notifications based on the actions' notification settings. Recovery actions only run if the rule's conditions aren't met during the current rule execution, but were in the previous one.
    An active alert changes to recovered if the conditions for the rule that generated it are no longer met.
    A flapping alert changes to recovered when the rule's conditions are unmet for a specific number of consecutive runs. This number is determined by the **Alert status change threshold** setting, which you can configure under the **Alert flapping detection** settings.
    For example, if the threshold requires an alert to change status at least 6 times in the last 10 runs to be considered flapping, then to recover, the rule's conditions must remain unmet for 6 consecutive runs. If the rule's conditions are met at any point during this recovery period, the count of consecutive unmet runs will reset, requiring the alert to remain unmet for an additional 6 consecutive runs to finally be reported as recovered.
    Once a flapping alert is recovered, it cannot be changed to flapping again. Only new alerts with repeated status changes are candidates for the flapping status.
  </definition>
  <definition term="untracked">
    The rule is disabled, or you’ve marked the alert as untracked. To mark the alert as untracked, go to the Alerts table, click the action menu icon `boxes_vertical` and select **Mark as untracked**. When an alert is marked as untracked, actions are no longer generated and the alert's status can no longer be changed. You can choose to move active alerts to this state when you disable or delete rules.
  </definition>
</definitions>


## Mute alerts

If an alert is active or flapping, you can mute it to temporarily suppress future actions. While muted, the alert's status will continue to update but rule actions won't run. All future alerts with the same alert ID will also be muted. You can mute alerts in the following ways:
<applies-switch>
  <applies-item title="stack: ga 9.3+" applies-to="Elastic Stack: Generally available since 9.3">
    You can mute individual alerts or multiple ones:
    - Mute individual alerts: Find the **Alerts** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), open the action menu (`boxes_vertical`) for the appropriate alert, then select **Mute**.
    - Bulk-mute alerts: Select one or more alerts from the **Alerts** management page, click **Selected _x_ alerts** at the upper-left above the table, then select **Mute selected**. Select the **Unmute selected** option to unmute alerts. Muted alerts display the icon `bellSlash` in the Alerts table.
  </applies-item>

  <applies-item title="stack: ga 9.0-9.2" applies-to="Elastic Stack: Generally available from 9.0 to 9.2">
    You can only mute individual alerts. To mute an alert, find the **Alerts** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), click the action menu icon `boxes_vertical` for the appropriate alert, then select **Mute**.
  </applies-item>
</applies-switch>

<note>
  To permanently suppress an alert's actions, open the actions menu for the appropriate alert, then select **Mark as untracked**. In this case, the alert's status is no longer updated and actions are no longer run. These changes are only applied to the alert that you untracked and cannot be reverted. Future alerts with the same alert ID are unaffected.To affect the behavior of the rule rather than individual alerts, check out [Snooze and disable rules](/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#controlling-rules).
</note>


## Apply and filter alert tags

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Use alert tags to organize related alerts into categories that you can filter and group. For example, use the `Production` alert tag to label a group of alerts as notifications from your production environment. Then, to find alerts with the `Production` tag, enter the `kibana.alert.workflow_tags : "Production"` query into the Alert's table KQL bar.
<tip>
  To display alert tags in the Alerts table, click **Fields**, then add the `kibana.alert.workflow_tags` field.
</tip>

To apply or remove alert tags on individual alerts:
1. Go to the Alerts table, click the **More actions** menu `boxes_vertical` in an alert’s row, then select **Edit tags**.
2. In the flyout, do one of the following:
   - Apply a new tag: Enter a new tag into the search bar, then select the **Add _tag name_ as a tag** or click enter on your keyboard to apply your changes.
- Remove existing tags: Click the tag that you want to remove. To remove all tags from the alert, click **Select none**.
  <important>
  Removing tags from an alert permanently deletes them.
  </important>
3. Click **Save selection** to apply your changes to the alert.

To apply or remove alert tags on multiple alerts, select the alerts you want to change, then click **Selected *x* alerts** at the upper-left above the table. Click **Edit alert tags**, select or unselect tags, then click **Save selection**.

## Clean up alerts

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Preview from 9.1 to 9.3
</applies-to>

Manage the size of alert indices in your space by clearing out alerts that are older or infrequently accessed. You can do this by running an alert cleanup task, which deletes alerts according to the criteria that you define.
<note>
  The alert cleanup task permanently deletes alerts in your `.alert-*` indices. Make sure to take regular snapshots of your cluster to back up your alert data in case you ever need to restore it.
</note>


### Prerequisites

- To run the alert cleanup task, your role must have `All` privileges for the **Alert deletion feature**. When setting your role’s Kibana privileges, go to **Management > Rule Settings**, enable **Customize sub-feature privileges**, then select `All` for the **Alert deletion** feature.
- Alerts in your space must be older than a day. The minimum threshold for the alert cleanup task is one day.


### Run the alert cleanup task

Remove old or rarely-accessed alerts in your space by running an alert cleanup task, which deletes alerts according to the criteria that you define. Alerts that are attached to cases are not deleted.
1. Open the **Rules** page by going to **Stack Management > Alerts and Insights > Rules** in the main menu or using the global search field.
2. Click **Settings** to open the settings for all rules in the space.
3. In the **Clean up alert history** section, click **Clean up**.
4. Define criteria for the alert cleanup task. You can choose to delete alerts that are active or inactive and meet a certain age.
   <tip>
   At the bottom of the modal, you can find a preview of the number of alerts that will be deleted according to the criteria that you define.
   </tip>
   - **Active alerts**: Choose to delete alerts that haven't had their status changed since they were initially generated and are older than the threshold that you specify.
  For example, if you specify two years as the threshold, the cleanup task will delete alerts that were generated more than two years ago and have never had their status changed.
- **Inactive alerts**: Choose to delete alerts that have had their statuses changed since they were initially created and are older than the threshold that you specify. Inactive alerts have had their status changed to recovered, closed, acknowledged, or untracked.
  For example, if you specify two years, the cleanup task will delete alerts that have had their status changed to recovered, closed, acknowledged, or untracked more than two years ago.
5. Enter **Delete** to verify that you want to run the alert cleanup task, then click **Run cleanup task**.

A message confirming that the alert cleanup task has started running appears. This information is also provided at the top of the alert cleanup modal in the **Last cleanup task: details** field. Note the field doesn't display in the modal until an alert cleanup task is run.