﻿---
title: Test connectors
description: In Stack Management > Connectors, you can test a newly created connector by navigating to the Test tab of Connector Edit flyout or by clicking "Save &...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/testing-connectors
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Test connectors
In **Stack Management > Connectors**, you can test a newly created connector by navigating to the Test tab of Connector Edit flyout or by clicking "Save & test" button on Create flyout:
![Rule management page with the errors banner](https://www.elastic.co/docs/explore-analyze/images/kibana-connector-save-and-test.png)

or by directly opening the proper connector edit flyout:
![Rule management page with the errors banner](https://www.elastic.co/docs/explore-analyze/images/kibana-email-connector-test.png)

![Five clauses define the condition to detect](https://www.elastic.co/docs/explore-analyze/images/kibana-teams-connector-test.png)


## Troubleshooting connectors with the `kbn-action` tool

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview
</applies-to>

You can run an email action via [kbn-action](https://github.com/pmuellr/kbn-action). In this example, it is a Cloud hosted deployment of the Elastic Stack:
```txt
$ npm -g install pmuellr/kbn-action

$ export KBN_URLBASE=https://elastic:<password>@<cloud-host>.us-east-1.aws.found.io:9243

$ kbn-action ls
[
    {
        "id": "a692dc89-15b9-4a3c-9e47-9fb6872e49ce",
        "actionTypeId": ".email",
        "name": "gmail",
        "config": {
            "from": "test@gmail.com",
            "host": "smtp.gmail.com",
            "port": 465,
            "secure": true,
            "service": null
        },
        "isPreconfigured": false,
        "isDeprecated": false,
        "referencedByCount": 0
    }
]
```

You can then run the following test:
```txt
$ kbn-action execute a692dc89-15b9-4a3c-9e47-9fb6872e49ce '{subject: "hallo", message: "hallo!", to:["test@yahoo.com"]}'
{
    "status": "ok",
    "data": {
        "accepted": [
            "test@yahoo.com"
        ],
        "rejected": [],
        "envelopeTime": 100,
        "messageTime": 955,
        "messageSize": 521,
        "response": "250 2.0.0 OK  1593144408 r5sm8625873qtc.20 - gsmtp",
        "envelope": {
            "from": "test@gmail.com",
            "to": [
                "test@yahoo.com"
            ]
        },
        "messageId": "<cf9fec58-600f-64fb-5f66-6e55985b935d@gmail.com>"
    },
    "actionId": "a692dc89-15b9-4a3c-9e47-9fb6872e49ce"
}
```