﻿---
title: Rule types
description: A rule is a set of conditions, schedules, and actions that enable notifications. Kibana provides rules built into the Elastic Stack and rules registered...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-types
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rule types
A rule is a set of [conditions](/docs/explore-analyze/alerts-cases/alerts#rules-conditions), [schedules](/docs/explore-analyze/alerts-cases/alerts#rules-schedule), and [actions](/docs/explore-analyze/alerts-cases/alerts#rules-actions) that enable notifications. Kibana provides rules built into the Elastic Stack and rules registered by one of the Kibana apps. You can create most rules types in [Stack Management > Rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules). Security rules must be defined in the Security app. For more information, refer to the documentation about [creating a detection rule](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-detection-rule).
<note>
  Some rule types are subscription features, while others are free features. For a comparison of the Elastic subscription levels, see [the subscription page](https://www.elastic.co/subscriptions).
</note>


## Stack rules

[Stack rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules) are built into Kibana. To access the **Stack Rules** feature and create and edit rules, users require the `all` privilege. See [feature privileges](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges#kibana-feature-privileges) for more information.

|                                                                                                              |                                                                                                                                                                                                                                                                                      |
|--------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Elasticsearch query](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-type-es-query)    | Run a user-configured Elasticsearch query, compare the number of matches to a configured threshold, and schedule actions to run when the threshold condition is met.                                                                                                                 |
| [Index threshold](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-type-index-threshold) | Aggregate field values from documents using Elasticsearch queries, compare them to threshold values, and schedule actions to run when the thresholds are met.                                                                                                                        |
| [Transform rules](https://www.elastic.co/docs/explore-analyze/transforms/transform-alerts)                   | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Run scheduled checks on a continuous transform to check its health. If a continuous transform meets the conditions, an alert is created and the associated action is triggered. |
| [Tracking containment](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/geo-alerting)         | Run an Elasticsearch query to determine if any documents are currently contained in any boundaries from a specified boundary index and generate alerts when a rule’s conditions are met.                                                                                             |


## Observability rules

Observability rules detect complex conditions in your observability data and create alerts when a rule’s conditions are met. For example, you can create a rule that detects when the value of a metric exceeds a specified threshold or when an anomaly occurs on a system or service you are monitoring. For more information, refer to [Alerting](https://www.elastic.co/docs/solutions/observability/incident-management/alerting).
<note>
  If you create a rule in the Observability app, its alerts are not visible in **Stack Management > Rules**. They are visible only in the Observability app.
</note>


## Machine learning rules

<applies-to>
  - Elastic Cloud Serverless: Beta
  - Elastic Stack: Beta
</applies-to>

[Machine learning rules](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts) run scheduled checks on an anomaly detection job to detect anomalies with certain conditions. If an anomaly meets the conditions, an alert is created and the associated action is triggered.

## Security rules

Security rules detect suspicious source events with pre-built or custom rules and create alerts when a rule’s conditions are met. For more information, refer to [Security rules](https://www.elastic.co/docs/reference/security/prebuilt-rules).
<note>
  Alerts associated with security rules are visible only in the Elastic Security app; they are not visible in **Stack Management > Rules**.
</note>