﻿---
title: Notifications domain allowlist
description: The notifications domain allowlist restricts the possible recipients for alert emails. Elasticsearch Watcher and Kibana alerting actions send emails only...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/notifications-domain-allowlist
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Notifications domain allowlist
The notifications domain allowlist restricts the possible recipients for alert emails. Elasticsearch Watcher and Kibana alerting actions send emails only if the recipient domains are included in this allowlist.
<note>
  The recipients are only restricted if one or more domains are configured. If there are no domains configured, notifications can be sent to any recipient domain (No restrictions apply).
</note>

You can configure the allowlist on the organization [Contacts](https://cloud.elastic.co/account/contacts?page=docs&placement=docs-body) page.
<warning>
  Changes to the allowlist do not take effect immediately. After saving your changes, run a configuration change on each of your deployments to apply the updated allowlist.
</warning>


## Apply the updated domain allowlist to a deployment


### Using the UI

1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Select a deployment.
3. From your deployment menu, go to the **Edit** page.
4. Select **Save**.

This updates the notifications settings for Elasticsearch and Kibana to reflect what is configured on the organizations **Contacts** page.

### Use the Elastic Cloud Control CLI

Updating multiple deployments through the UI can take a lot of time. Instead, you can use the [Elastic Cloud Control](https://www.elastic.co/docs/reference/ecctl) command-line interface (`ecctl`) to automate the deployment update.
The following example script shows how to update all deployments of an organization:
```bash
$!/bin/bash
ecctl deployment list --format "{{ .ID }}" | while read id ; do
    echo "Updating deployment $id"
    temp_file=$(mktemp)

    # Get current deployment formatted as an update request
    # The request is stored into a temporary file
    ecctl deployment show $id --generate-update-payload > $temp_file

    # Update the deployment using this request
    ecctl deployment update $id --file $temp_file

    rm $temp_file
done
```