﻿---
title: Maintenance windows
description: This content applies to: Observability Security You can schedule single or recurring maintenance windows to temporarily reduce rule notifications. For...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows
products:
  - Elastic Cloud Serverless
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview from 9.0 to 9.1
---

# Maintenance windows
This content applies to: [![Observability](https://www.elastic.co/docs/explore-analyze/images/serverless-obs-badge.svg)](https://www.elastic.co/docs/solutions/observability) [![Security](https://www.elastic.co/docs/explore-analyze/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)
You can schedule single or recurring maintenance windows to temporarily reduce rule notifications. For example, a maintenance window prevents false alarms during planned outages.
By default, a maintenance window affects all rules in all Kibana apps within its space. You can refine the scope of a maintenance window by adding filters and rule categories.
Alerts continue to be generated, however notifications are suppressed as follows:
- When an alert occurs during a maintenance window, there are no notifications. When the alert recovers, there are no notifications—even if the recovery occurs after the maintenance window ends.
- When an alert occurs before a maintenance window and recovers during or after the maintenance window, notifications are sent as usual.


## Configure access to maintenance windows

To use maintenance windows, you must have the appropriate [subscription](https://www.elastic.co/subscriptions) and Kibana feature privileges.
- To have full access to maintenance windows, you must have `All` privileges for the **Management > Maintenance Windows** feature.
- To have view-only access to maintenance windows, you must have `Read` privileges for the **Management > Maintenance Windows** feature.

For more details, refer to [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).

## Create and manange maintenance windows

In **Management > Stack Management > Maintenance Windows** or **Project settings > Management > Maintenance Windows** in Serverless, you can create, edit, cancel, and archive maintenance windows.
<applies-to>Elastic Stack: Generally available since 9.1</applies-to> In Elastic Stack 9.1.0 and later, you can also delete maintenance windows that are running, canceled, or archived. Be aware that you can't recover maintenance windows once you delete them.
When you create a maintenance window, you must provide a name and a schedule. You can optionally configure it to repeat daily, monthly, yearly, or on a custom interval.
![The Create Maintenance Window user interface in Kibana](https://www.elastic.co/docs/explore-analyze/images/kibana-create-maintenance-window.png)

By default, maintenance windows affect all categories of rules. The category-specific maintenance window options alter this behavior. For the definitive list of rule types in each category, refer to the [get rule types API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-alerting).
<note>
  <applies-to>Elastic Stack: Removed in 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Removed</applies-to> The option to specify rule categories for a maintenance window is no longer available. Maintenance windows apply to all rule types.Note that existing maintenance windows are still applied to rule categories that were specified. However, if you edit a maintenance window after upgrading or using the latest version of Serverless, specified rule categories are removed and the maintenance window will be applied to all rules types.
</note>

If you turn on **Filter alerts**, you can use KQL to filter the alerts affected by the maintenance window:
![The Create Maintenance Window user interface in Kibana with alert filters turned on](https://www.elastic.co/docs/explore-analyze/images/kibana-create-maintenance-window-filter.png)

<note>
  - <applies-to>Elastic Stack: Removed in 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Removed</applies-to> You can select only a single category when you turn on filters.
  - Some rules are not affected by maintenance window filters because their alerts do not contain requisite data. In particular, [Stack Monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts), [tracking containment](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/geo-alerting), [anomaly detection jobs health](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts), and [transform health](https://www.elastic.co/docs/explore-analyze/transforms/transform-alerts) rules are not affected by the filters.
</note>

A maintenance window can have any one of the following statuses:
- `Upcoming`: It will run at the scheduled date and time.
- `Running`: It is running.
- `Finished`: It ended and does not have a repeat schedule.
- `Archived`: It is archived. In a future release, archived maintenance windows will be queued for deletion.

When you [view alert details](/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#rule-details) in Kibana, each alert shows unique identifiers for maintenance windows that affected it.