﻿---
title: Create and manage alerting rules with Kibana
description: The Stack Management > Rules UI provides a cross-app view of alerting. Different Kibana apps like Observability, Security, Maps and Machine Learning can...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create and manage alerting rules with Kibana
The **Stack Management** > **Rules** UI provides a cross-app view of alerting. Different Kibana apps like [**Observability**](https://www.elastic.co/docs/solutions/observability/incident-management/alerting), [**Security**](https://www.elastic.co/docs/reference/security/prebuilt-rules), [**Maps**](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/geo-alerting) and [**Machine Learning**](https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana) can offer their own rules.
You can find **Rules** in **Stack Management** > **Alerts and insights** > **Rules** in Kibana or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
![Rules page navigation](https://www.elastic.co/docs/explore-analyze/images/kibana-stack-management-rules.png)
**Rules** provides a central place to:
- [Create and edit](#create-edit-rules) rules
- [Manage rules](#controlling-rules) including enabling/disabling, muting/unmuting, and deleting
- Drill down to [rule details](#rule-details)
- Configure rule settings

For more information on alerting concepts and the types of rules and connectors available, go to [Alerting](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts).

## Required permissions

Access to rules is granted based on your alerting features privileges. For more information, go to [Security](/docs/explore-analyze/alerts-cases/alerts/alerting-setup#alerting-security).

## Create and edit rules

Some rules must be created within the context of a Kibana app like [Metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts), [**APM**](https://www.elastic.co/docs/solutions/observability/apm), or [Uptime](https://www.elastic.co/docs/solutions/observability/uptime), but others are generic. Generic rule types can be created in **Rules** by clicking the **Create rule** button. This will launch a flyout that guides you through selecting a rule type and configuring its conditions and actions.
After a rule is created, you can open the action menu (…) and select **Edit rule** to re-open the flyout and change the rule properties.
<tip>
  You can also manage rules as resources with the [Elasticstack provider](https://registry.terraform.io/providers/elastic/elasticstack/latest) for Terraform. For more details, refer to the [elasticstack_kibana_alerting_rule](https://registry.terraform.io/providers/elastic/elasticstack/latest/docs/resources/kibana_alerting_rule) resource.
</tip>


### Rule type and conditions

Depending on the Kibana app and context, you might be prompted to choose the type of rule to create. Some apps will preselect the type of rule for you.
Each rule type provides its own way of defining the conditions to detect, but an expression formed by a series of clauses is a common pattern. For example, in an Elasticsearch query rule, you specify an index, a query, and a threshold, which uses a metric aggregation operation (`count`, `average`, `max`, `min`, or `sum`):
![UI for defining rule conditions in an Elasticsearch query rule](https://www.elastic.co/docs/explore-analyze/images/kibana-rule-types-es-query-conditions.png)

All rules must have a check interval, which defines how often to evaluate the rule conditions. Checks are queued; they run as close to the defined value as capacity allows.
For details on what types of rules are available and how to configure them, refer to [*Rule types*](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-types).

### Alert flapping

You can modify the criteria for changing an alert's status to [`flapping`](/docs/explore-analyze/alerts-cases/alerts/view-alerts#alert-status) by configuring the **Alert flapping detection** settings, which are turned on by default. When configuring flapping settings, you must set a look back window and threshold for alert status changes. For example, you can specify that alerts with at least 6 status changes in the last 10 runs are `flapping`.
<applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can modify the flapping settings for a specific rule while creating or editing it. You can also modify the flapping settings for all rules in your Kibana space or Serverless project. To do this, go to the **Rules** page (find the **Rules** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects)), click **Settings**, then go to the **Alert flapping detection** settings.
<applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> You can only modify global flapping settings for your entire Kibana space or Serverless project.

### Actions

You can add one or more actions to your rule to generate notifications when its conditions are met and when they are no longer met.
Each action uses a connector, which provides connection information for a Kibana service or third party integration, depending on where you want to send the notifications.
<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> Some connectors that perform actions within Kibana, such as the [Cases connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type), require less configuration. For example, you do not need to set the action frequency or variables.
After you select a connector, set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. Alternatively, you an choose to run actions for each alert (at each check interval, only when the alert status changes, or at a custom interval).
<note>
  If you choose a custom action interval, it cannot be shorter than the rule’s check interval.
</note>

For example, if you create an Elasticsearch query rule, you can send notifications that summarize the new, ongoing, and recovered alerts on a custom interval:
![UI for defining alert summary action in an Elasticsearch query rule](https://www.elastic.co/docs/explore-analyze/images/kibana-es-query-rule-action-summary.png)

When you choose to run actions for each alert, you must specify an action group. Each rule type has a set of valid action groups, which affect when an action runs. For example, you can set **Run when** to `Query matched` or `Recovered` for the Elasticsearch query rule:
![UI for defining a recovery action](https://www.elastic.co/docs/explore-analyze/images/kibana-es-query-rule-recovery-action.png)

Connectors have unique behavior for each action group. For example, you can have actions that create an Opsgenie alert when rule conditions are met and recovery actions that close the Opsgenie alert. For more information about connectors, refer to [*Connectors*](https://www.elastic.co/docs/deploy-manage/manage-connectors).
<tip>
  If you are not using alert summaries, actions are generated per alert and a rule can end up generating a large number of actions. Take the following example where a rule is monitoring three servers every minute for CPU usage > 0.9, and the action frequency is `On check intervals`:
  - Minute 1: server X123 > 0.9. *One email* is sent for server X123.
  - Minute 2: X123 and Y456 > 0.9. *Two emails* are sent, one for X123 and one for Y456.
  - Minute 3: X123, Y456, Z789 > 0.9. *Three emails* are sent, one for each of X123, Y456, Z789.
  In this example, three emails are sent for server X123 in the span of 3 minutes for the same rule. Often, it’s desirable to suppress these re-notifications. If you set the action frequency to `On custom action intervals` with an interval of 5 minutes, you reduce noise by getting emails only every 5 minutes for servers that continue to exceed the threshold:
  - Minute 1: server X123 > 0.9. *One email* will be sent for server X123.
  - Minute 2: X123 and Y456 > 0.9. *One email* will be sent for Y456.
  - Minute 3: X123, Y456, Z789 > 0.9. *One email* will be sent for Z789.
  To get notified only once when a server exceeds the threshold, you can set the action frequency to `On status changes`. Alternatively, consider using alert summaries to reduce the volume of notifications.
</tip>


### Action variables

You can pass rule values to an action at the time a condition is detected. To view the list of variables available for your rule, click the "add rule variable" button:
![Passing rule values to an action](https://www.elastic.co/docs/explore-analyze/images/kibana-es-query-rule-action-variables.png)

For more information about common action variables, refer to [*Rule action variables*](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).

## Snooze and disable rules

The rule listing enables you to quickly snooze, disable, enable, or delete individual rules. For example, you can change the state of a rule:
![Use the rule status dropdown to enable or disable an individual rule](https://www.elastic.co/docs/explore-analyze/images/kibana-individual-enable-disable.png)
If there are rules that are not currently needed, disable them to stop running checks and reduce the load on your cluster.
When you snooze a rule, the rule checks continue to run on a schedule but alerts will not generate actions. You can snooze for a specified period of time, indefinitely, or schedule single or recurring downtimes:
![Snooze notifications for a rule](https://www.elastic.co/docs/explore-analyze/images/kibana-snooze-panel.png)
When a rule is in a snoozed state, you can cancel or change the duration of this state.
<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> To temporarily suppress notifications for rules, you can also create a [maintenance window](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows).

## View rule details

You can determine the health of a rule by looking at the **Last response** in **Stack Management** > **Rules**. A rule can have one of the following responses:
<definitions>
  <definition term="failed">
    The rule ran with errors.
  </definition>
  <definition term="succeeded">
    The rule ran without errors.
  </definition>
  <definition term="warning">
    The rule ran with some non-critical errors.
  </definition>
</definitions>

Click the rule name to access a rule details page:
![Rule details page with multiple alerts](https://www.elastic.co/docs/explore-analyze/images/kibana-rule-details-alerts-active.png)

In this example, the rule detects when a site serves more than a threshold number of bytes in a 24 hour period. Four sites are above the threshold. These are called alerts - occurrences of the condition being detected - and the alert name, status, time of detection, and duration of the condition are shown in this view. Alerts come and go from the list depending on whether the rule conditions are met. For more information about alerts, go to [*View alerts*](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/view-alerts).
If there are rule actions that failed to run successfully, you can see the details on the **History** tab. In the **Message** column, click the warning or expand icon ![double arrow icon to open a flyout with the document details](https://www.elastic.co/docs/explore-analyze/images/kibana-expand-icon-2.png) or click the number in the **Errored actions** column to open the **Errored Actions** panel. In this example, the action failed because the [`xpack.actions.email.domain_allowlist`](https://www.elastic.co/docs/reference/kibana/configuration-reference/alerting-settings#action-config-email-domain-allowlist) setting was updated and the action’s email recipient is no longer included in the allowlist:
![Rule histor page with alerts that have errored actions](https://www.elastic.co/docs/explore-analyze/images/kibana-rule-details-errored-actions.png)


## Import and export rules

To import and export rules, use [saved objects](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects).
<note>
  Some rule types cannot be exported through this interface:**Security rules** can be imported and exported using the [Security UI](/docs/solutions/security/detect-and-alert/manage-detection-rules#import-export-rules-ui).**Stack monitoring rules** are [automatically created](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts) for you and therefore cannot be managed in **Saved Objects**.
</note>

Rules are disabled on export. You are prompted to re-enable the rule on successful import.
![Rules import banner](https://www.elastic.co/docs/explore-analyze/images/kibana-rules-imported-banner.png)