﻿---
title: Set up
description: Kibana alerting features are automatically enabled, but might require some additional configuration. If you are using an on-premises Elastic Stack deployment:...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/alerting-setup
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Set up
Kibana alerting features are automatically enabled, but might require some additional configuration.

## Prerequisites

If you are using an **on-premises** Elastic Stack deployment:
- In the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file, add the [`xpack.encryptedSavedObjects.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/alerting-settings#general-alert-action-settings) setting.
- For emails to have a footer with a link back to Kibana, set the [`server.publicBaseUrl`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) configuration setting.

If you are using an **on-premises** Elastic Stack deployment with [**security**](https://www.elastic.co/docs/deploy-manage/security):
- If you are unable to access Kibana alerting features, ensure that you have not [explicitly disabled API keys](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#api-key-service-settings).

The alerting framework uses queries that require the `search.allow_expensive_queries` setting to be `true`. See the scripts [documentation](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-query#_allow_expensive_queries_4).

## Production considerations and scaling guidance

When relying on alerting and actions as mission critical services, make sure you follow the [alerting production considerations](https://www.elastic.co/docs/deploy-manage/production-guidance/kibana-alerting-production-considerations).
For more information on the scalability of alerting features, go to [Scaling guidance](/docs/deploy-manage/production-guidance/kibana-alerting-production-considerations#alerting-scaling-guidance).

## Security

To use alerting features in a Kibana app, you must have the appropriate feature privileges:

### Give full access to manage alerts, connectors, and rules in **Stack Management**

**Kibana privileges**
- `All` for the **Management > Stack Rules** feature.
- `All` for the **Management > Rules Settings** feature.
- `All` for the **Management > Actions and Connectors** feature.

<note>
  The **Actions and Connectors** feature privilege is required to manage connectors. To add rule actions and test connectors, you require only `Read` privileges. By default, `All` privileges include authority to run Endpoint Security connectors (such as SentinelOne and CrowdStrike) unless you customize the sub-feature privileges.Likewise, you can customize the **Rules Settings** sub-feature privileges related to flapping detection settings.To create a rule that uses the [Cases connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type), you must also have `All` privileges for the **Cases** feature.The rule type also affects the privileges that are required to create and edit rules. For example:
  - For machine learning rules, you must have `all` privileges for the **Analytics > Machine Learning** feature.
  - For Stack Monitoring rules, you must have the `monitoring_user` role.
  - For most Observability rules, you must have `all` privileges for the appropriate Observability features. However, for a custom threshold rule, you only need the `stack alerts` privilege.
  - For Security rules, refer to [Turn on detections](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-requirements).
</note>


### Give view-only access to alerts, connectors, and rules in  **Stack Management**

**Kibana privileges**
- `Read` for the **Management > Stack Rules** feature.
- `Read` for the **Management > Rules Settings** feature.
- `Read` for the **Management > Actions and Connectors** feature.

<note>
  The rule type also affects the privileges that are required. For example, to view machine learning rules, you must have `read` privileges for the **Analytics > Machine Learning** feature. For Stack Monitoring rules, you must have the `monitoring_user` role. For Observability rules, you must have `read` privileges for the appropriate Observability features. For Security rules, refer to [Turn on detections](https://www.elastic.co/docs/solutions/security/detect-and-alert/detections-requirements).
</note>


### Give view-only access to alerts in **Discover** or **Dashboards**

**Kibana privileges**
- `Read` index privileges for the `.alerts-*` system indices.


### Revoke all access to alerts, connectors, and rules in **Stack Management**, **Discover**, or **Dashboards**

**Kibana privileges**
- `None` for the **Management > Stack Rules** feature.
- `None` for the **Management > Rules Settings** feature.
- `None` for the **Management > Actions and Connectors** feature.
- No index privileges for the `.alerts-*` system indices.


### More details

For more information on configuring roles that provide access to features, go to [Feature privileges](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges#kibana-feature-privileges).

### API keys

Rules are authorized using an API key. Its credentials are used to run all background tasks associated with the rule, including condition checks like Elasticsearch queries and triggered actions.
When you create a rule in Kibana, an API key is created that captures a snapshot of your privileges. Likewise when you update a rule, the API key is updated with a snapshot of your privileges at the time of the edit.
When you disable a rule, it retains the associated API key which is reused when the rule is enabled. If the API key is missing when you enable the rule, a new key is generated that has your current security privileges. When you import a rule, you must enable it before you can use it and a new API key is generated at that time.
You can generate a new API key at any time in **Stack Management > Rules** or in the rule details page by selecting **Update API key** in the actions menu.
If you manage your rules by using Kibana APIs, they support support both key- and token-based authentication as described in [Authentication](https://www.elastic.co/docs/api/doc/kibana/authentication). To use key-based authentication, create API keys and use them in the header of your API calls as described in [API Keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys). To use token-based authentication, provide a username and password; an API key that matches the current privileges of the user is created automatically. In both cases, the API key is subsequently associated with the rule and used when it runs.
<important>
  If a rule requires certain privileges, such as index privileges, to run and a user without those privileges updates the rule, the rule will no longer function. Conversely, if a user with greater or administrator privileges modifies the rule, it will begin running with increased privileges. The same behavior occurs when you change the API key in the header of your API calls.
</important>


### Restrict actions

For security reasons you may wish to limit the extent to which Kibana can connect to external services. You can use [Action settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to disable certain [*Connectors*](https://www.elastic.co/docs/deploy-manage/manage-connectors) and allowlist the hostnames that Kibana can connect with.

## Space isolation

Rules and connectors are isolated to the Kibana space in which they were created. A rule or connector created in one space will not be visible in another.

## Cross-cluster search

If you want to use alerting rules with cross-cluster search, you must configure privileges for CCS and Kibana. Refer to [Remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters).