﻿---
title: Alerts and cases
description: Alerting tools in Elasticsearch and Kibana provide functionality to monitor data and notify you about significant changes or events in real time. This...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases
products:
  - Elastic Cloud Serverless
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Alerts and cases
Alerting tools in Elasticsearch and Kibana provide functionality to monitor data and notify you about significant changes or events in real time. This page provides an overview of how the key components work.

## Alerts

Alerts are notifications generated when specific conditions are met. These notifications are sent to you through channels that you previously set such as email, Slack, webhooks, PagerDuty, and so on. Alerts are created based on rules, which define the criteria for triggering them. Rules monitor the data indexed in Elasticsearch and evaluate conditions on a defined schedule to identify matches. For example, a threshold rule can generate an alert when a value crosses a specific threshold, while a machine learning rule activates an alert when an anomaly detection job identifies an anomaly.

## Cases

Cases are a collaboration and tracking tool, which is particularly useful for incidents or issues that arise from alerts. You can group related alerts into a case for easier management, add notes and comments to provide context, track investigation progress, and assign cases to team members or link them to external systems. Cases ensure that teams have a central place to track and resolve alerts efficiently.

## Maintenance windows

If you have a planned outage, maintenance windows prevent rules from generating notifications in that period. Alerts still occur but their notifications are suppressed.

### Workflow Example

1. **Rule Creation**: You set up a rule to monitor server logs for failed login attempts exceeding 5 within a 10-minute window.
2. **Alert Generation**: When the rule's condition is met, an alert is created.
3. **Notification**: The alert runs an action, such as sending a Slack message or an email, unless a maintenance window is active.
4. **Case Management**: If the alert is part of an ongoing investigation, it's added to a case for further analysis and resolution.

By combining these tools, Elasticsearch and Kibana enable incident response workflows, helping teams to detect, investigate, and resolve issues efficiently.

## Watcher

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

You can use Watcher for alerting and monitoring specific conditions in your data. It enables you to define rules and take automated actions when certain criteria are met. Watcher is a powerful alerting tool for custom use cases and more complex alerting logic. It allows advanced scripting using Painless to define complex conditions and transformations.
<tip>
  For most use cases, you should use Kibana Alerts instead of Watcher. Kibana Alerts allows rich integrations across use cases like APM, metrics, security, and uptime. Prepackaged rule types simplify setup and hide the details of complex, domain-specific detections, while providing a consistent interface across Kibana.Watcher is not available in Elastic Cloud Serverless.
</tip>