﻿---
title: Manage access to AI features
description: The GenAI Settings page lets you control access to AI-powered features in the following ways: Manage which AI connectors are available in your environment.Enable...
url: https://www.elastic.co/docs/explore-analyze/ai-features/manage-access-to-ai-assistant
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Manage access to AI features
The GenAI Settings page lets you control access to AI-powered features in the following ways:
- Manage which AI connectors are available in your environment.
- Enable or disable AI Assistant and other AI-powered features in your environment.
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Unavailable</applies-to> Specify in which Elastic solutions the `AI Assistant for Observability and Search` and the `AI Assistant for Security` appear.


## Requirements

- To access the **GenAI Settings** page, you need the `Actions and connectors: all` or `Actions and connectors: read` [Kibana privilege](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).
- To modify the settings on this page, you need the `Advanced Settings: all` Kibana privilege.


## The GenAI Settings page

To manage these settings, go to the **GenAI Settings** page by using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<applies-switch>
  <applies-item title="serverless: ga" applies-to="Elastic Cloud Serverless: Generally available">
    ![GenAI Settings page for Serverless](https://www.elastic.co/docs/explore-analyze/images/ai-assistant-settings-page-serverless.png)The **GenAI Settings** page has the following settings:
    - **Default AI Connector**: Click **Manage connectors** to open the **Connectors** page, where you can create or delete AI connectors. To update these settings, you need the `Actions and connectors: all` [Kibana privilege](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).
    - **AI feature visibility**: Click **Go to Permissions tab** to access the active Kibana space's settings page, where you can specify which features each [user role](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) has access to in your environment. This includes AI-powered features.
  </applies-item>

  <applies-item title="stack: ga 9.2+" applies-to="Elastic Stack: Generally available since 9.2">
    ![GenAI Settings page for Stack](https://www.elastic.co/docs/explore-analyze/images/ai-assistant-settings-page.png)The **GenAI Settings** page has the following settings:
    - **Default AI Connector**: Use this setting to specify which connector is selected by default when you access AI-powered features. Default setting: **No default connector**.
      - If **No default connector** is selected, AI-powered features will default to the connector that was most recently used in your environment.
    - If an **Elastic Managed LLM** or a custom LLM connector is selected, AI-powered features will default to that connector regardless of which connector was used most recently in your environment.
    - **Disallow all other connectors**: When this setting is disabled, whenever you use an AI-powered feature you can select which connector should power it. Enable it to prevent connectors other than the default connector from being used in your space. Default setting: disabled.
    - **AI feature visibility**: This button opens the current Space's settings page, where you can specify which features are enabled in your environment, including AI-powered features.
    - **Chat experience**: <applies-to>Elastic Stack: Preview since 9.3</applies-to> Select whether to use AI Assistant or AI Agent. For information about choosing one, refer to [Compare AI Agent and AI Assistant](https://www.elastic.co/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant).
    - **AI Assistant visibility**: This setting allows you to choose which AI Assistants are available to use and where. There are several options:
      - **Only in their solutions** (default): The Security AI Assistant appears in Elastic Security, and the Elastic AI Assistant for Observability and Search appears in Elasticsearch and Observability.
    - **Elastic AI Assistant for Observability and Search in other apps**: The Elastic AI Assistant for Observability and Search appears throughout Kibana regardless of solution. The Security AI Assistant does not appear anywhere.
    - **Security AI Assistant in other apps**: The Security AI Assistant appears throughout Kibana regardless of solution. The Elastic AI Assistant for Observability and Search does not appear anywhere.
    - **Hide all assistants**: Turns off AI Assistant throughout Kibana.
  </applies-item>
</applies-switch>