﻿---
title: Elastic Agent Builder
description: Elastic Agent Builder combines large language models with Elastic-native features for prompt engineering, context engineering, and automation. Key use...
url: https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Elastic Agent Builder
Elastic Agent Builder combines large language models with Elastic-native features for prompt engineering, context engineering, and automation. Key use cases enabled by Agent Builder include:
- **Chat with your Elasticsearch data immediately** using the chat interface, preconfigured agents, and built-in tools available out of the box.
- **Build custom agents and tools** tailored to your specific use cases using the UI or APIs.
- **Import tools from external MCP servers** to give your agents additional capabilities.
- **Expose tools and agents to external systems** like Claude Desktop, Cursor, and LangChain apps through the MCP server, A2A server, and REST APIs.

**[Learn more in key capabilities](#key-capabilities)**

## Get started

To get started you need an Elastic deployment and you might need to enable the feature.
[**Get started with Elastic Agent Builder**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started)
<admonition title="Admonition">
  This feature requires the appropriate Elastic Stack [subscription](https://www.elastic.co/pricing) or Serverless [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>


## Key capabilities

- **Elasticsearch relevance and security**: Leverage Elasticsearch's search capabilities for precise context retrieval, with [secure data access controls](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/permissions).
- **Built-in agents and tools**: Get started immediately with pre-configured [agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference) and [tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference) available out of the box.
- **Chat UI**: [Chat with agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat) in real time using natural language.
- **Custom and external tools**: Build targeted [custom tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools) to deliver precise context, or import external tools through the [Model Context Protocol](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/mcp-tools).
- **Custom agents**: Create [agents with tailored instructions](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/custom-agents) and toolsets for specific use cases.
- **MCP and A2A servers**: Expose tools and agents to external clients through the [MCP server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/mcp-server) and [A2A server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/a2a-server).
- **Kibana REST APIs**: Work with Agent Builder functionalities [programmatically](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/kibana-api), including agents, tools, and conversations.
- **[Elastic Workflows](https://www.elastic.co/docs/explore-analyze/workflows) integration**: Automate complex processes within your deployment using the Elastic-native automation engine. Your agents can [trigger workflows](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agents-and-workflows) and [workflows can invoke agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agents-and-workflows) in their steps.


## Key concepts

The Elastic Agent Builder framework consists of three key components: Agent Chat, Agents, and Tools.

### Agent Chat

**Agent Chat** is the synchronous chat interface for interacting with agents through natural language. The chat UI enables real-time communication where you can ask questions, request data analysis, and receive immediate responses from your configured agents. You can also chat with agents programmatically.
[**Learn more about Agent Chat**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat)

### Agents

Agents are powered by custom LLM instructions and the ability to use tools to answer questions, take action, or support workflows. Each agent translates natural language requests into specific actions using the tools assigned to it. Choose from a set of built-in agents, or create your own.
[**Learn more about agents**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agent-builder-agents)

### Tools

Tools are modular, reusable functions that agents use to search, retrieve, and manipulate Elasticsearch data. Tools are the primary mechanism for connecting agent capabilities to your data. Choose from a set of built-in tools, or create your own and assign them to your custom agents.
[**Learn more about tools**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools)

## Model selection

On Elastic Cloud Hosted and Elastic Cloud Serverless, Elastic Agent Builder comes with preconfigured models ready to use. You can also configure other model providers using connectors, including local LLMs deployed on your infrastructure.
[**Learn more about model selection**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/models)

## Programmatic interfaces

Elastic Agent Builder provides APIs and LLM integration options for programmatic access and automation.
These interfaces enable you to build integrations with other applications and extend Elastic Agent Builder's capabilities to fit your specific requirements.
[**Learn more about programmatic access**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/programmatic-access)

## Permissions and access control

Configure security roles and API keys to control who can use agents, which tools they can access, and what data they can query.
[**Learn more about permissions and access control**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/permissions)

## Monitor usage

Understand how tokens are calculated and accumulated during agent execution to predict the impact on your usage and costs.
[**Learn more about token usage**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage)

## Troubleshooting

Find solutions to common problems when working with Elastic Agent Builder.
[**Learn more about troubleshooting**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting)

## Limitations and known issues

Understand current limitations and known issues with Elastic Agent Builder.
[**Learn more about limitations and known issues**](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues)