﻿---
title: AI assistants in Kibana
description: AI Assistant is a chat-based interactive tool that can help with a variety of tasks throughout Elasticsearch and Kibana, including: Constructing queries:...
url: https://www.elastic.co/docs/explore-analyze/ai-features/ai-chat-experiences/ai-assistant
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# AI assistants in Kibana
**AI Assistant** is a chat-based interactive tool that can help with a variety of tasks throughout Elasticsearch and Kibana, including:
- **Constructing queries**: Assists you in building queries to search and analyze your data, including converting queries from other languages to [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql).
- **Indexing data**: Guides you on how to index data into Elasticsearch.
- **Using APIs**: Calls Elasticsearch APIs on your behalf if you need specific operations performed.
- **Generating sample data**: Helps you create sample data for testing and development purposes.
- **Visualizing and analyzing data**: Assists you in creating visualizations and analyzing your data using Kibana.
- **Troubleshooting**: Explains errors, messages, and suggests remediation.
- **Investigating threats**: Helps analyze potential attacks, provides threat research, and assists with alert triage.

AI Assistant requires specific privileges and a large language model (LLM) connector. The capabilities and ways to interact with AI Assistant can differ for each solution. To learn more about how it works in each solution, refer to:
- [Elastic AI Assistant for Observability and Search](https://www.elastic.co/docs/solutions/observability/ai/observability-ai-assistant)
- [AI Assistant for Security](https://www.elastic.co/docs/solutions/security/ai/ai-assistant)

To learn more about configuring LLM connectors, refer to:
- [Enable LLM access](https://www.elastic.co/docs/explore-analyze/ai-features/llm-guides/llm-connectors)


## Prompt best practices

Elastic AI Assistant allows you to take full advantage of the Elastic platform to improve your operations. It can help you write an ESQL query for a particular use case, or answer general questions about how to use the platform. Its ability to assist you depends on the specificity and detail of your questions. The more context and detail you provide, the more tailored and useful its responses will be.
To maximize its usefulness, consider using more detailed prompts or asking for additional information. For instance, after asking for an ESQL query example, you could ask a follow-up question like, “Could you give me some other examples?” You can also ask for clarification or further exposition, for example "Provide comments explaining the query you just gave".
In addition to practical advice, AI Assistant can offer conceptual advice, tips, and best practices for enhancing your security measures. You can ask it, for example:
- “How do I set up a machine learning job in Elastic Security to detect anomalies in network traffic volume over time?”
- “I need to monitor for unusual file creation patterns that could indicate ransomware activity. How would I construct this query using EQL?”


## Your data and AI Assistant

Elastic does not use customer data for model training. This includes anything you send the model, such as alert or event data, detection rule configurations, queries, and prompts. However, any data you provide to AI Assistant will be processed by the third-party provider you chose when setting up the generative AI connector as part of the assistant setup.
Elastic does not control third-party tools, and assumes no responsibility or liability for their content, operation, or use, nor for any loss or damage that may arise from your using such tools. Exercise caution when using AI tools with personal, sensitive, or confidential information. Any data you submit may be used by the provider for AI training or other purposes. There is no guarantee that the provider will keep any information you provide secure or confidential. You should familiarize yourself with the privacy practices and terms of use of any generative AI tools prior to use.

## Elastic Managed LLMs

[Elastic Managed LLMs](https://www.elastic.co/docs/reference/kibana/connectors-kibana/elastic-managed-llm) are available in Kibana deployments and serverless projects with an appropriate [subscription or feature tier](https://www.elastic.co/pricing). They provide immediate access to generative AI features without requiring any setup or external model integration.
Elastic Managed LLMs are available out-of-the box. They do not require manual configuration or API key management. Alternatively, you can configure and use third-party LLM connectors, such as OpenAI, Azure, or Amazon Bedrock.
To learn more about security and data privacy, refer to [Elastic Managed LLMs](https://www.elastic.co/docs/reference/kibana/connectors-kibana/elastic-managed-llm) which provides details on the models.
<important>
  Using Elastic Managed LLMs incurs additional costs. Refer to [Elastic Cloud pricing](https://www.elastic.co/pricing/serverless-search) for more information.
</important>