﻿---
title: API calls return 403 Forbidden in Elastic Agent Builder
description: Learn how to diagnose and resolve 403 Forbidden errors when using Agent Builder.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/api-calls-return-403-forbidden
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# API calls return 403 Forbidden in Elastic Agent Builder
A `403 Forbidden` error occurs when you don't have access to the required subscription or feature tier for Elastic Agent Builder.

## Symptoms

API calls to Elastic Agent Builder endpoints return a `403 Forbidden` HTTP status code.

## Cause

Elastic Agent Builder requires specific subscription levels depending on your deployment type.

## Resolution

Upgrade to the required subscription or feature tier for your deployment type. To learn more, refer to [Manage your subscription](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription).

## Related pages

- [Get started](/docs/explore-analyze/ai-features/agent-builder/get-started#enable-agent-builder)
- [Manage your subscription](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription)