﻿---
title: Troubleshooting Elastic Agent Builder
description: Resolve common errors and configuration issues in Agent Builder.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Troubleshooting Elastic Agent Builder
Use the topics in this section to troubleshoot common problems with Elastic Agent Builder.
- [Context length exceeded](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded)
- [API calls return `403 Forbidden`](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/api-calls-return-403-forbidden)


## Related pages

- [Limitations and known issues](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues)
- [Monitor token usage](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage)
- [Best practices for prompt engineering in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/prompt-engineering)
- [Create and manage custom tools in Elastic Agent Builder > Best practices](/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools#best-practices)