﻿---
title: Workflow tools in Elastic Agent Builder
description: Create custom tools that allow agents to trigger Elastic Workflows directly from a chat conversation to perform deterministic tasks.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/workflow-tools
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Workflow tools in Elastic Agent Builder
Workflow tools enable agents to trigger [Elastic Workflows](https://www.elastic.co/docs/explore-analyze/workflows) directly from a conversation and use their output. This is ideal for offloading tasks from the LLM that require a deterministic, repeatable sequence of actions.
<note>
  This page explains how to trigger a workflow in an agent conversation. If you want to use an agent within a workflow step, refer to [Call agents from workflows](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agents-and-workflows).
</note>


## Prerequisites

Before you begin:
- Familiarize yourself with the core concepts of [Elastic Workflows](https://www.elastic.co/docs/explore-analyze/workflows).
- [Set up workflows](https://www.elastic.co/docs/explore-analyze/workflows/setup): Enable the Workflows feature and ensure you have the correct privileges to create and run workflows.
- Create at least one workflow.


## Add a Workflow tool

Follow these steps to configure a workflow tool:
1. Navigate to **Agents > More > View all tools > New tool**.

![Screenshot of creating a new workflow tool.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/create-new-tool-workflows.png)

1. Select **Workflow** as the tool type.
2. Select a workflow from the drop down list.
3. Fill in the [configuration fields](#configuration).
4. Click **Save**.


## Configuration

The Workflow tools have the following configuration settings:
<definitions>
  <definition term="Tool ID">
    A unique identifier for the tool.
  </definition>
  <definition term="Description">
    A natural language explanation of what the tool does. The agent uses this description to decide *when* to call the tool.
  </definition>
  <definition term="Example: "Use this tool when the user asks to investigate an alert regarding the payment service."">
  </definition>
  <definition term="Workflow">
    The specific Elastic Workflow to execute. Selecting a workflow automatically pulls its definition into the tool configuration.
  </definition>
  <definition term="Inputs">
    The parameters required by the workflow. These are automatically detected from the `inputs` section of the selected workflow's YAML definition. The agent will attempt to extract values for these inputs from the user's chat message.
  </definition>
  <definition term="Labels (Optional)">
    Tags used to organize and filter tools within the Elastic Agent Builder UI.
  </definition>
</definitions>


## Call workflows from chat

Once you've created a workflow tool, you must assign it to an agent to make it available in chat.

### Assign tool to agent

To assign a tool to an agent:
1. Navigate to **Agents**.
2. Select your agent.
3. Select **More > Edit Agent > Tools**
4. Assign the workflow tool by selecting the checkbox.
5. Click **Save**.


### Trigger a workflow

To test your workflow tool, open the [Agent chat UI](/docs/explore-analyze/ai-features/agent-builder/chat#agent-chat-gui) and ask a question that triggers the workflow.
The agent:
- extracts the necessary parameters from the conversation
- runs the workflow
- returns the workflow's final output to the chat

Expand the **Completed reasoning** section to trace the execution steps and inspect the raw workflow output.
![Screenshot of reasoning steps of agent builder.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agent-builder-workflow-tool.png)


## Examples

The [`elastic/workflows` GitHub repo](https://github.com/elastic/workflows) contains more than 50 examples you can use as a starting point.

## Related pages

- [Tools overview](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools)
- [Call agents from workflows](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agents-and-workflows)
- [Workflows](https://www.elastic.co/docs/explore-analyze/workflows)