﻿---
title: Model Context Protocol (MCP) tools in Elastic Agent Builder
description: Connect to external MCP servers to enable agents to use remote tools and services.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/mcp-tools
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Model Context Protocol (MCP) tools in Elastic Agent Builder
Agent Builder MCP tools enable calling a remote [MCP server's](https://modelcontextprotocol.io/docs/learn/server-concepts) tools in your agent [chat](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat). When your agent calls an MCP tool, it executes the associated tool on the MCP server and returns its result.

## Prerequisites

To use external MCP tools, you first need to set up an [MCP connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/mcp-action-type). This interface enables Agent Builder MCP tools to communicate with a remote MCP server.

## Adding MCP tools

You can import MCP tools individually or in bulk.

### Add a single tool

Once you've set up an MCP connector, click "New tool" on the [Tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools) landing page and select the `MCP` tool type.
![Example configuration for a new MCP tool with the Context7 MCP server.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-createnewtool-config-example.png)


#### Configuration

Individual MCP tools have the following configuration settings:
<definitions>
  <definition term="MCP Server">
    The MCP connector to interface with.
  </definition>
  <definition term="Tool">
    The specific tool on MCP server to create an Agent Builder MCP tool for.
  </definition>
</definitions>

Once a tool is selected, the `Tool ID` and `Description` fields automatically populate with the tool name and description provided by the MCP server.

### Bulk import MCP tools

To import multiple tools at once, go to the [Tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools) landing page and select **Bulk import MCP tools** from the "Manage MCP" dropdown.
![How to bulk import MCP tools from an MCP server.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-bulkimport-location.png)

Configure the following fields:
<definitions>
  <definition term="MCP Server">
    The MCP connector to interface with.
  </definition>
  <definition term="Tools to import">
    The specific tools from the MCP server to import.
  </definition>
  <definition term="Namespace">
    A string to prepend to the tool name to aid in searching and organization. A namespace must start with a letter and contain only lowercase letters, numbers, and hyphens.
  </definition>
</definitions>

![Example configuration for bulk importing MCP tools from the Context7 MCP server.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-bulkimport-config-example.png)

After clicking **Import tools**, Agent Builder creates an MCP tool for each selection.
Each tool's ID is generated as `namespace.tool-name` (for example, `context7.resolve-library-id`), and descriptions are populated automatically from the MCP server.

## How MCP tool calls work

When an agent calls an MCP tool:
1. Agent Builder retrieves the tool's input schema from the MCP connector.
2. Agent Builder calls the MCP server tool with the required parameters.
3. The MCP server returns the result directly to the LLM with no post-processing.
4. The LLM interprets the result for the user.


## Monitoring tool health

MCP tools have built-in health monitoring. Tools that are unhealthy display an icon next to their IDs in the [Tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools) landing page.
An MCP tool is marked "unhealthy" when:
- The MCP tool's associated MCP connector is unavailable.
  ![Connector unavailable icon.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-connector-unavailable.png)
- The MCP tool's associated tool on the MCP server no longer exists.
  ![Tool not found icon.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-tool-not-found.png)
- The MCP tool's execution failed.
  ![Tool execution failed icon.](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/mcp-tool-execution-failed.png)


## Related pages

- [Tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools)
- [ES|QL tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/esql-tools)
- [Index search tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/index-search-tools)