﻿---
title: Index search tools in Elastic Agent Builder
description: Create custom tools that allow agents to intelligently search specific Elasticsearch index patterns using natural language.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/index-search-tools
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Index search tools in Elastic Agent Builder
Index search tools provide intelligent, natural language-driven search over specified Elasticsearch resources. Instead of defining explicit queries, you specify a pattern of [indices](https://www.elastic.co/docs/manage-data/data-store/index-basics), [aliases](https://www.elastic.co/docs/manage-data/data-store/aliases), or [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams), and the tool uses a combination of built-in capabilities to intelligently interpret and execute search requests. The tool automatically generates queries in Query DSL or ES|QL format based on the search intent.

## When to use index search tools

Use custom **Index search tools** when:
- You want agents to handle diverse, exploratory queries
- The search intent varies significantly across requests
- Users need flexible, dynamic search functionality
- You want to scope general search capabilities to specific indices


## Key characteristics

- Accept natural language queries from the agent
- Automatically determine optimal search strategy (full-text, semantic)
- Leverage built-in tools like index exploration, query generation, and semantic search
- Ideal for flexible, user-driven exploratory searches
- No need to pre-define query logic


## Configuration

Index search tools support the following configuration parameters:
<definitions>
  <definition term="pattern">
    An index pattern string specifying which indices, aliases, or data streams to search. Examples: `logs-myapp-*`, `my-index`, `.alerts-security-*`.
    <tip>
      [Avoid overly broad wildcard patterns](#wildcard-warning) like `*` or `logs-*` across large datasets.
    </tip>
  </definition>
  <definition term="row_limit (optional)">
    Maximum number of rows to return from ES|QL queries. This helps control the amount of data retrieved and prevents exceeding context length limits.
  </definition>
  <definition term="custom_instructions (optional)">
    Domain-specific guidance for ES|QL query generation. For example: `"Always include @timestamp and filter out records where environment='test'"`.
  </definition>
</definitions>


## How it works

When an agent calls an index search tool:
1. The agent provides a natural language query (for example, "find recent errors related to authentication")
2. The tool analyzes the query intent and available indices
3. It automatically orchestrates built-in tools to:
   - Explore the index structure and mappings
- Generate appropriate queries (ES|QL or query DSL)
- Execute semantic search if relevant
- Rank and format results
4. Returns results in a format the agent can interpret and present

To help agents make better decisions during the source selection phase, you can optimize your index metadata and tool configurations.

## Add index metadata to improve agent search

You can add metadata to your index mappings to help agents make better decisions. Index-level [`_meta.description`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-meta-field) helps agents select the appropriate indices.

#### Example: Add index-level metadata

```json

{
  "_meta": {
    "description": "Primary dataset for North American customer orders in 2025. Use this for questions about order values, shipping status, or customer purchase history. Do not use for real-time inventory levels—use the inventory index instead. RELATIONSHIPS: 'customer_id' links to 'customer-profiles' index. NOTES: 'total_amount' includes tax; use 'subtotal' for pre-tax calculations." <1>
  },
  "properties": {
    "order_id": { "type": "keyword" },
    "total_amount": { "type": "double" }, <2>
    "created_at": { "type": "date" },
    "customer_support_notes": { "type": "text" }
  }
}
```

<important>
  Keep descriptions concise (a few sentences) to avoid [context overflow](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded).
</important>


## Best practices

- **Add index [metadata](#add-index-metadata-to-improve-agent-search) descriptions**: Include `_meta.description` fields in your index mappings. Keep descriptions concise (a few sentences) to avoid [context overflow](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded).
  - Explain what entities or events the index covers
- Note what types of questions it can answer
- Document how fields link to other indices
- State what the index should NOT be used for
- Clarify non-obvious field meanings or calculations
- **Use specific patterns**: Scope tools to relevant index patterns rather than broad wildcards (for example, `logs-myapp-*` instead of `logs-*`)
- **Write descriptive tool names**: Help agents select the right tool for the query (for example, "Search Security Alerts" vs. "Search Tool")
- **Provide context in descriptions**: Explain what data the indices contain and what types of questions the tool can answer
- **Create domain-specific tools**: Build separate tools for different data domains (logs, metrics, alerts) rather than one general-purpose tool. In enterprise environments with hundreds of indices, creating scoped search tools prevents the agent from wasting tokens scanning irrelevant data. For example, a "Finance Agent" should not search through "Customer Support" logs.
- **Add custom instructions**: Use the custom instructions parameter to guide ES|QL query generation with domain-specific requirements, such as always including certain fields, applying specific filters, or handling time ranges in a particular way
- **Set appropriate row limits**: Configure row limits to prevent retrieving excessive data that could exceed context length limits

For general guidance on naming tools and writing effective descriptions, refer to [Custom tools best practices](/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools#best-practices).
<tip>
  Creating scoped, domain-specific tools also helps prevent [context length issues](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded) by reducing the volume of data the agent needs to process.
</tip>


## Common patterns

The following examples show typical index patterns and domain-specific tool configurations.

### Index pattern syntax

- **Wildcard patterns**: `logs-*`, `metrics-*`, `events-*`
- **Specific indices**: `products`, `users`, `orders`

Instead of creating a single generic search tool, consider creating multiple focused tools that target specific data domains. This gives the agent a smaller, higher-quality list of potential data sources, reducing the chance of retrieving irrelevant data.
<dropdown title="Support logs tool example">
  **Tool name**: `Search Support Logs`**Pattern**: `logs-support-*`**Description**: "Search through server and application logs for error traces, stack traces, and diagnostic information. Use this when troubleshooting technical support tickets or investigating system issues."
</dropdown>

<dropdown title="Finance invoices tool example">
  **Tool name**: `Search Invoices`**Pattern**: `finance-invoices-*`**Description**: "Search through settled and pending invoices. Use this to retrieve payment status, billing addresses, or invoice details for accounting queries."
</dropdown>

<dropdown title="Security alerts tool example">
  **Tool name**: `Search Security Alerts`**Pattern**: `security-alerts-*`**Description**: "Search security detection alerts and findings. Use this for questions about threat detection, suspicious activity, or security incidents."
</dropdown>


<warning>
  Avoid overly broad patterns like `*` or `logs-*` across large datasets. Broad wildcards can cause the agent to retrieve more data than the LLM can process, resulting in slow responses or errors. Refer to [Context length exceeded](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded) for tips on diagnosing and resolving these issues.
</warning>