﻿---
title: Elastic Agent Builder built-in tools reference
description: Reference of all built-in tools available in Elastic Agent Builder.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Elastic Agent Builder built-in tools reference
This page lists all built-in tools available in Elastic Agent Builder. Built-in tools enable core operations for working with Elasticsearch data across platform, observability, and security use cases out-of-the-box.
Built-in tools are read-only: you can't modify or delete them. To check which tools are available in your Elastic deployment, refer to [Manage tools](/docs/explore-analyze/ai-features/agent-builder/tools#manage-tools).
<tip>
  For an overview of how tools work in Elastic Agent Builder, refer to the [Tools overview](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools).
</tip>


## Availability

Built-in platform core tools are available across all deployments, while observability and security tools are available in their respective serverless projects (or solution views). Tools use consistent prefixes (`platform.core`, `observability`, `security`) that reflect this scoping.

## Agents and tools

[Built-in agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference) are pre-configured with relevant tools. For example, the Observability agent includes all observability tools by default. You can assign any available built-in tools to [custom agents](/docs/explore-analyze/ai-features/agent-builder/custom-agents#create-a-new-agent) you create.

## Platform core tools

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
  - Elastic Stack: Preview in 9.2
</applies-to>

Platform core tools provide fundamental capabilities for interacting with Elasticsearch data, executing queries, and working with indices. They are relevant to many use cases.
<note>
  All [built-in agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference) are assigned these tools by default.
</note>

<definitions>
  <definition term="platform.core.execute_esql">
    Executes an [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) query and returns the results in a tabular format.
  </definition>
  <definition term="platform.core.generate_esql">
    Generates an [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) query from a natural language query.
  </definition>
  <definition term="platform.core.get_document_by_id">
    Retrieves the full content of an Elasticsearch document based on its ID and index name.
  </definition>
  <definition term="platform.core.get_index_mapping">
    Retrieves mappings for the specified index or indices.
  </definition>
  <definition term="platform.core.index_explorer">
    Lists relevant indices and corresponding mappings based on a natural language query.
  </definition>
  <definition term="platform.core.list_indices">
    Lists the indices, aliases, and data streams in the Elasticsearch cluster the current user has access to.
  </definition>
  <definition term="platform.core.search">
    Searches and analyzes data within your Elasticsearch cluster using full-text relevance searches or structured analytical queries.
  </definition>
  <definition term="platform.core.product_documentation Elastic Stack: Generally available since 9.3">
    Searches and retrieves documentation about Elastic products. To use this tool, search for **GenAI Settings** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) and install **Elastic documentation** from the **Documentation** section. This takes a few minutes.
  </definition>
  <definition term="platform.core.integration_knowledge Elastic Stack: Generally available since 9.3">
    Searches and retrieves knowledge from [Fleet](https://www.elastic.co/docs/reference/fleet)-installed integrations, including information on how to configure and use integrations for data ingestion.
  </definition>
</definitions>

<definitions>
  <definition term="platform.core.cases Elastic Stack: Generally available since 9.3">
    Searches and retrieves [cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases) for tracking and managing issues.
  </definition>
  <definition term="platform.core.get_workflow_execution_status Elastic Stack: Generally available since 9.3">
    Retrieves the execution status of a workflow.
  </definition>
</definitions>


## Observability tools

<applies-to>
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

Observability tools provide specialized capabilities for monitoring applications, infrastructure, and logs.
<note>
  The [built-in Observability agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#observability-agent) is assigned these tools by default.
</note>

<definitions>
  <definition term="observability.get_alerts">
    Retrieves Observability [alerts](https://www.elastic.co/docs/solutions/observability/incident-management/alerting) within a specified time range, supporting filtering by status (active/recovered) and KQL queries.
  </definition>
  <definition term="observability.get_services">
    Retrieves information about services being monitored in [APM](https://www.elastic.co/docs/solutions/observability/apm).
  </definition>
  <definition term="observability.get_hosts">
    Retrieves information about hosts being monitored in infrastructure monitoring.
  </definition>
  <definition term="observability.get_index_info">
    Retrieves information about Observability indices and their fields. Supports operations for getting an overview of available data sources, listing fields that contain actual data, and retrieving distinct values or ranges for specific fields.
  </definition>
  <definition term="observability.get_trace_metrics">
    Retrieves metrics and statistics for distributed traces.
  </definition>
  <definition term="observability.get_downstream_dependencies">
    Identifies downstream dependencies (other services, databases, external APIs) for a specific service to understand service topology and blast radius.
  </definition>
  <definition term="observability.get_log_categories">
    Retrieves categorized log patterns to identify common log message types.
  </definition>
  <definition term="observability.get_log_change_points">
    Detects statistically significant changes in log patterns and volumes.
  </definition>
  <definition term="observability.get_metric_change_points">
    Detects statistically significant changes in metrics across groups (for example, by service, host, or custom fields), identifying spikes, dips, step changes, and trend changes.
  </definition>
  <definition term="observability.get_correlated_logs">
    Finds logs that are correlated with a specific event or time period.
  </definition>
  <definition term="observability.run_log_rate_analysis">
    Analyzes log ingestion rates to identify anomalies and trends.
  </definition>
  <definition term="observability.get_anomaly_detection_jobs">
    Retrieves Machine Learning [anomaly detection jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) and their top anomaly records for investigating outliers and abnormal behavior.
  </definition>
</definitions>


## Security tools

<applies-to>
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

Security tools provide specialized capabilities for security monitoring, threat detection, and incident response.
<note>
  The [built-in Threat Hunting Agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#threat-hunting-agent) is assigned these tools by default.
</note>

<definitions>
  <definition term="security.alerts">
    Searches and analyzes security alerts using full-text or structured queries for finding, counting, aggregating, or summarizing alerts.
  </definition>
</definitions>

<definitions>
  <definition term="security.security_labs_search">
    Searches [Elastic Security Labs](https://www.elastic.co/security-labs) research and threat intelligence content. To use this tool, search for **GenAI Settings** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) and install **Security labs** from the **Documentation** section. This takes a few minutes.
  </definition>
</definitions>

<tip>
  You can also manage tools programmatically. To learn more, refer to [Tools API](/docs/explore-analyze/ai-features/agent-builder/tools#tools-api).
</tip>


## Related pages

- [Tools in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools)
- [Custom ES|QL tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/esql-tools)
- [Custom index search tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/index-search-tools)