﻿---
title: Tools in Elastic Agent Builder
description: Learn how Agent Builder tools enable agents to search data and perform actions in Elasticsearch. Explore built-in tools, custom tool definitions, and MCP integration.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Tools in Elastic Agent Builder
[Agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agent-builder-agents) use tools to search, retrieve, and take actions on your behalf.
Tools can be thought of as functions: modular, reusable actions that agents can call to interact with your Elasticsearch data.

## How agents use tools

Tools enable agents to work with Elasticsearch data. When an agent receives a natural language query, it does the following:
1. Analyzes the semantic intent of the request
2. Selects appropriate tools from its available toolset
3. Maps the request parameters to tool input parameters
4. Executes the tools in sequence as needed
5. Processes the structured output data

Each tool is an atomic operation with a defined signature. Tools accept typed parameters and return structured results in a format the agent can parse, transform, and incorporate into its response generation.
<note>
  Tool execution and result processing consume tokens. To understand how usage is calculated, refer to [Token usage in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage).
</note>


## Built-in tools

Elastic Agent Builder ships with a comprehensive set of built-in tools that provide core capabilities for working with your Elasticsearch data. These tools are ready to use. They cannot be modified or deleted.
Built-in tools serve as building blocks for more complex interactions and provide the foundation for agent capabilities.
For the complete list, refer to [Built-in tools reference](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference).

## Custom tools

You can extend the built-in tool catalog with your own custom tool definitions. To learn how to create and manage custom tools, refer to [Custom tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools).

## Manage tools

You can view, organize, and manage tools from the **Tools** page in Kibana or programmatically using the [Tools API](/docs/explore-analyze/ai-features/agent-builder/kibana-api#tools-apis).
The Tools page lists each tool by ID and description. Use the search bar or filter by labels to find specific tools. Built-in tools are marked with a lock icon (🔒).
![Tools landing page showing the list of available tools with their descriptions and actions](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/tools-overview.png)


### Update and delete tools

[Custom tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools) can be modified or removed as needed:
1. From the Tools page, find the tool you want to modify.
2. Select the edit icon to update the tool or the delete icon to remove it.
3. For updates, modify the tool properties and save your changes.

<note>
  Built-in tools cannot be modified or deleted.
</note>


## Tools API

For a quick overview of how to work programmatically with tools, refer to [Tools API](/docs/explore-analyze/ai-features/agent-builder/kibana-api#tools-apis).

### API reference

For the complete API reference, refer to the [Kibana API reference](https://www.elastic.co/docs/api/doc/kibana/operation/operation-get-agent-builder-tools).

## Copy your MCP server URL

Tools can also be accessed through the Model Context Protocol (MCP) server, which provides a standardized interface for external clients to use Agent Builder tools.
The **Tools** UI provides a **Copy your MCP server URL** button for easy access.
![Copy MCP server URL button for easy configuration of external clients](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/copy-mcp-server-url-button.png)

<important>
  There is a [known issue](/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues#mcp-server-url-copy-button-omits-space-name) with the copy button in 9.2.
</important>

For detailed MCP server configuration, refer to [MCP server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/mcp-server).