﻿---
title: Chat UI modes in Elastic Agent Builder
description: Learn how to use Agent Builder chat UI modes. Switch between the full-page standalone interface and the persistent flyout for seamless multitasking in Kibana.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/standalone-and-flyout-modes
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Chat UI modes in Elastic Agent Builder
The Elastic Agent Builder [chat UI](/docs/explore-analyze/ai-features/agent-builder/chat#agent-chat-gui) is available in two modes:
1. [Standalone mode](#standalone-mode)
2. [Flyout mode](#flyout-mode)

<note>
  The standalone and flyout modes have the same functionalities and can be used interchangeably. Conversation history is preserved across both modes.
</note>


## Standalone mode

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
  - Elastic Stack: Preview in 9.2
</applies-to>

Access Agent Builder by selecting **Agents** in the main navigation. In Elastic Observability and Elastic Security, the standalone experience is available when you [switch from AI Assistant to Agent Builder](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences).
![Agents logo in main navigation](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agents-nav.png)

The following GIF shows how to access the standalone chat experience in an Elastic Security project:
![Standalone agent builder chat mode in main navigation](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/standalone-chat-mode.gif)


## Flyout mode

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview in 9.3
</applies-to>

Once you [switch from AI Assistant to Agent Builder](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences), you can access the flyout in two ways:
1. Select the **AI Agent** button from the header bar in any page:

![AI Agent button](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/ai-agent-flyout-button.png)

1. Use the keyboard shortcut:
   - Mac: <kbd>Cmd</kbd> + <kbd>;</kbd>
- Windows/Linux: <kbd>Ctrl</kbd> + <kbd>;</kbd>

You can resize the flyout by dragging its side edge. The flyout persists when you change pages in the main navigation.
![Flyout chat mode demonstration](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/flyout-chat-mode.gif)


## Default chat experiences

The default chat experience varies by solution:
- **Elastic Observability and Elastic Security:** Each solution's classic AI Assistant is the default chat experience. You must [switch between chat experiences](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences) to enable Agent Builder.
  - Once enabled:
  - The flyout experience replaces the AI Assistant chat experience
- The standalone experience is available through the **Agents** button in the main navigation.
- **Elasticsearch:** Agent Builder appears in the navigation automatically.


## Related pages

- [Agent Builder chat UI](/docs/explore-analyze/ai-features/agent-builder/chat#agent-chat-gui)
- [Switch between AI assistant and Agent Builder chat](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences)