﻿---
title: Programmatic access to Elastic Agent Builder
description: Learn how to integrate with Agent Builder using the MCP server, A2A protocol, or Kibana REST APIs. Extend AI capabilities to external clients like Claude and Cursor.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/programmatic-access
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Programmatic access to Elastic Agent Builder
Elastic Agent Builder provides comprehensive integration options for programmatic access and automation.
These interfaces enable you to build integrations with other applications and extend Agent Builder's capabilities to fit your specific requirements.
<tip>
  Most users will probably want to integrate with Agent Builder using MCP or A2A, but you can also work programmatically with tools, agents, and conversations using the Kibana APIs.
</tip>

- **[MCP server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/mcp-server)**: A standardized interface that allows external MCP clients (such as Claude Desktop or Cursor) to access Elastic Agent Builder tools.
- **[A2A server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/a2a-server)**: Agent-to-agent communication endpoints that follow the A2A protocol specification, enabling external A2A clients to interact with Elastic Agent Builder agents.
- **[Kibana API](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/kibana-api)**: RESTful APIs for working with Elastic Agent Builder programmatically.