﻿---
title: Permissions and access control in Elastic Agent Builder
description: Learn how to configure security roles, API keys, and privileges for Agent Builder.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/permissions
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Permissions and access control in Elastic Agent Builder
Use this page to learn how to configure security roles and API keys for Elastic Agent Builder. Understanding these privileges helps you control who can use agents, which tools they can access, and what data they can query.
<admonition title="Admonition">
  This feature requires the appropriate Elastic Stack [subscription](https://www.elastic.co/pricing) or Serverless [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>


## Required privileges

Elastic Agent Builder requires privileges at three levels:
- [Kibana feature access](#kib-privileges)
- [Elasticsearch cluster access](#es-cluster-privileges)
- [Elasticsearch index access](#es-index-privileges)


### Kibana privileges

Elastic Agent Builder access control is managed by the `agentBuilder` Kibana feature:
- "Read" access to the `agentBuilder` feature: Required to use agents, send chat messages, view tools, and access conversations.
- "All" access to the `agentBuilder` feature: Required to create, update, or delete custom agents and tools.
- "Read" access to the "Actions and Connectors" feature: Required to use AI connectors with agents.

Learn more about [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).

### Elasticsearch cluster privileges

Elastic Agent Builder requires cluster-level privileges for AI-powered query generation:
- `monitor_inference`: Required when the agent uses an AI connector that calls the Elasticsearch Inference API (such as the Elastic default LLM or other AI connectors configured to use the Inference API). The built-in tools `search` and `generate_esql`, as well as [index search tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/index-search-tools), use this API to generate queries from natural language. This privilege is not required when the agent uses other Kibana GenAI connectors.

Learn more about [cluster privileges](https://www.elastic.co/guide/en/elasticsearch/reference/current/security-privileges.html#privileges-list-cluster).

### Elasticsearch index privileges

Tools execute queries against Elasticsearch indices as the current user. Required privileges depend on which indices the tools access:
- `read`: Required for tools that query data.
- `view_index_metadata`: Required for tools that inspect index structure. Also required for the built-in `search` tool and [index search tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/index-search-tools), which might use index exploration capabilities internally.

Learn more about [index privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices).

## Grant access

You can grant users access to Elastic Agent Builder using these methods:
- [Roles](#grant-access-with-roles) to bundle privileges for users.
- [API keys](#grant-access-with-api-keys) for programmatic access.
- [Spaces](#working-with-spaces) to scope access to specific environments.


### Grant access with roles

[Roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) are Elasticsearch security constructs that bundle together Kibana feature privileges and Elasticsearch privileges. To grant users access to Elastic Agent Builder, create a role that includes the required privileges.
<note>
  When configuring roles in the Kibana UI, Elastic Agent Builder privileges are currently located under the **Analytics** section, not the Elasticsearch section.
</note>

Example role for users who need full Elastic Agent Builder access:
```json
POST /_security/role/agent-builder-full
{
  "cluster": ["monitor_inference"],
  "indices": [
    {
      "names": ["logs-*", "metrics-*"],
      "privileges": ["read", "view_index_metadata"]
    }
  ],
  "applications": [
    {
      "application": "kibana-.kibana",
      "privileges": [
        "feature_agentBuilder.all",
        "feature_actions.read"
      ],
      "resources": ["space:default"]
    }
  ]
}
```

<tip>
  For read-only access, use `feature_agentBuilder.read` instead of `feature_agentBuilder.all`.
</tip>


### Grant access with API keys

When using the Elastic Agent Builder APIs programmatically, authenticate with an API key that includes the required privileges.
Unlike roles, which use UI-friendly feature privilege names like `feature_agentBuilder.all`, API keys use the underlying API privilege names (`read_onechat`, `manage_onechat`). This is because API keys interact directly with the Kibana API layer rather than through the UI.
Refer to these pages for API key configuration examples:
- [MCP server](/docs/explore-analyze/ai-features/agent-builder/mcp-server#api-key-application-privileges)
- [Kibana API](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/kibana-api)

Learn more about [API keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).

### Working with Spaces

Elastic Agent Builder respects Kibana Spaces when enabled. All conversations, custom agents, and custom tools are scoped to the current Space.
When configuring roles or API keys, specify the Space in the application privileges resources (e.g., `"resources": ["space:production"]`). Users and API keys cannot access resources in other Spaces.
Learn how to [Copy your MCP server URL](/docs/explore-analyze/ai-features/agent-builder/tools#copy-your-mcp-server-url).
<important>
  When accessing Elastic Agent Builder APIs or the MCP server from a custom Space, include the space name in the URL path: `https://<deployment>/s/<space-name>/api/agent_builder/...`The default space uses the standard URL format without `/s/<space-name>`.
</important>

Learn more about [Kibana Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces).