﻿---
title: Model configuration in Elastic Agent Builder
description: Learn how to configure LLMs in Agent Builder, including Elastic Managed LLMs using EIS and custom connectors for OpenAI, Claude, and Gemini.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/models
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Model configuration in Elastic Agent Builder
Elastic Agent Builder uses large language models (LLMs) to power agent reasoning and decision-making.
For Elastic Cloud Serverless projects and Elastic Cloud Hosted deployments, Elastic Agent Builder uses Elastic Managed LLMs running on the [Elastic Inference Service (EIS)](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis). This managed service requires zero setup.

## Default model configuration

<applies-switch>
  <applies-item title="{ ess:, serverless: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Cloud Hosted: Generally available">
    You can get started with zero setup using Elastic Managed LLMs. These are built-in LLMs running on the [Elastic Inference Service (EIS)](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis). This managed service requires no additional API key management.
    <note>
      Learn more about [Elastic Managed LLMs](https://www.elastic.co/docs/reference/kibana/connectors-kibana/elastic-managed-llm) and [pricing](https://www.elastic.co/pricing).
    </note>
  </applies-item>

  <applies-item title="{ece:, eck, self: preview =9.2, ga 9.3+}" applies-to="Elastic Cloud on Kubernetes: Generally available, Elastic Cloud Enterprise: Generally available, Self-managed Elastic deployments: Preview in 9.2">
    These deployments do not include a preconfigured connector. To use Elastic Agent Builder, you have two options:
    - [Configure a connector](#change-the-default-model)
    - [Connect to Elastic Inference Service (EIS) using Cloud Connect](https://www.elastic.co/docs/explore-analyze/elastic-inference/connect-self-managed-cluster-to-eis)
  </applies-item>
</applies-switch>


## Switch models in the UI

Use the model selector in the chat interface to switch between available models. The selector displays all configured models, including preconfigured models (on Elastic Cloud Hosted and Elastic Cloud Serverless) and any custom connectors you set up.
To learn more, refer to [select a different model](/docs/explore-analyze/ai-features/agent-builder/chat#select-a-different-model).
![Model selector dropdown in the chat interface](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/model-selector.png)


## Change the default model

To change which model is used by default:
1. Search for **GenAI Settings** in the global search field.
2. Select your preferred connector from the **Default AI Connector** dropdown.
3. Save your changes.


## Use additional models

To use additional models that aren't preconfigured, create a connector for your model provider.

### Create a connector in the UI

To create a new connector:
1. Find connectors under **Alerts and Insights / Connectors** in the [global search bar](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Create Connector** and select your model provider.
3. Configure the connector with your API credentials and preferred model.
4. Expand **Additional settings** and select `chat_completion` as the task type.
   ![Additional settings expanded showing chat_completion task type selected](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/additional-settings-chat-completion-task-type.png)

<tip>
  For detailed instructions on creating connectors, refer to [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).To learn about preconfigured connectors, refer to [preconfigured connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors).
</tip>


### Create connectors with the API

To create connectors programmatically, refer to the [Connectors API documentation](https://www.elastic.co/docs/api/doc/kibana//operation/operation-post-actions-connector-id).

### Connect a local LLM

You can connect a locally hosted LLM to Elastic using the OpenAI connector. This requires your local LLM to be compatible with the OpenAI API format.
For detailed setup instructions, refer to the [OpenAI connector documentation](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type).

## Model requirements

Elastic Agent Builder requires models with strong reasoning and tool-calling capabilities. State-of-the-art models perform significantly better than smaller or older models.
Agent Builder relies on advanced LLM capabilities including:
- **Function calling**: Models must accurately select appropriate tools and construct valid parameters from natural language requests.
- **Multi-step reasoning**: Agents need to plan, execute, and adapt based on tool results across multiple iterations.
- **Structured output**: Models must produce properly formatted responses that the agent framework can parse.

While Elastic offers LLM [connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana) for many different vendors and models, not all LLMs are robust enough to be used with Elastic Agent Builder.

### Recommended models

The following models are known to work well with Elastic Agent Builder. These categories represent a spectrum from maximum reasoning capability to maximum throughput. Choose based on your latency, cost, and complexity requirements.

| Category             | Model examples                   | Use cases                                                                                     | Trade-offs                                                                       |
|----------------------|----------------------------------|-----------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------|
| Extended reasoning   | - Gemini 3 Pro - Claude 4.5 Opus | Open-ended exploration, multi-step planning, and complex analysis                             | Higher latency and cost; best for latency-insensitive, batch, or async workflows |
| Balanced performance | - GPT-5.2 - Claude 4.5 Sonnet    | General-purpose agents requiring reliable tool orchestration and data retrieval and synthesis | Moderate cost; suitable for real-time and interactive use                        |
| High throughput      | GPT-OSS-120B                     | Latency-sensitive pipelines and high-concurrency scenarios with well-scoped tasks             | Lower reasoning depth; smaller context window; ideal for air-gapped deployments  |

<tip>
  For agents working with large documents or conversation histories, consider models with extended context windows. For example, Claude 4.5 Sonnet and Gemini 3 Pro support up to 1M tokens. Check your model provider's documentation for specific context limits.
</tip>


### Incompatible models

Smaller or less capable models may produce errors like:
```json
Error: Invalid function call syntax
```

```json
Error executing agent: No tool calls found in the response.
```

While any chat-completion-compatible connector can technically be configured, we strongly recommend using state-of-the-art models for reliable agent performance.
<note>
  Smaller or "mini" model variants are not recommended for Elastic Agent Builder as they lack the necessary capabilities for reliable agent workflows.
</note>


## Related pages

- [Limitations and known issues](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues): Current limitations around model selection
- [Get started](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started): Initial setup and configuration
- [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors): Detailed connector configuration guide