﻿---
title: Limitations and known issues in Elastic Agent Builder
description: Find limitations and known issues for Agent Builder.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Limitations and known issues in Elastic Agent Builder
This section lists the limitations and known issues in Elastic Agent Builder.
<admonition title="Admonition">
  This feature requires the appropriate Elastic Stack [subscription](https://www.elastic.co/pricing) or Serverless [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>


## Limitations

<tip>
  Refer to [Get started](/docs/explore-analyze/ai-features/agent-builder/get-started#enable-agent-builder) if you need instructions about enabling Elastic Agent Builder for your deployment type.
</tip>


### Cross-cluster search not supported in index search tools

Index search tool types do not yet support [cross-cluster search (CCS)](https://www.elastic.co/docs/explore-analyze/cross-cluster-search).

### A2A streaming not supported

The [A2A server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/a2a-server) does not currently support streaming operations. All agent interactions use the synchronous `message/send` method, which returns a complete response only after task execution completes.

### ES|QL limitations

ES|QL tools are subject to the current limitations of the [ES|QL language](https://www.elastic.co/docs/reference/query-languages/esql).
Ensure your cluster version supports the ES|QL features you intend to use.
For a complete list of ES|QL limitations, refer to the [ES|QL limitations documentation](https://www.elastic.co/docs/reference/query-languages/esql/limitations).

## Known issues


### Troubleshoot incompatible LLMs

The following errors suggest your selected model may not be compatible with Elastic Agent Builder:
```json
Error: Invalid function call syntax
```

```json
Error executing agent: No tool calls found in the response.
```

To learn more, refer to [Model configuration in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/models).

### Context length exceeded error

This error occurs when a conversation exceeds the maximum context length supported by the LLM. This typically happens when tools return large responses that consume the available token budget.
To learn more, refer to [Context length exceeded in Elastic Agent Builder conversations](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting/context-length-exceeded).

### Misinterpreted SQL syntax as ES|QL

The `.execute_esql` tool is designed only for [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) syntax, not other query languages.
When using SQL syntax with the default agent, it attempts to use the `.execute_esql` tool instead of recognizing the input as SQL.
This results in parsing errors like this:
```json
[
  {
    "type": "error",
    "data": {
      "message": "parsing_exception\n\tCaused by:\n\t\tinput_mismatch_exception: null\n\tRoot causes:\n\t\tparsing_exception: line 1:15: mismatched input 'WHERE' expecting {<EOF>, '|', ',', 'metadata'}",
      "stack": "ResponseError: parsing_exception\n\tCaused by:\n\t\tinput_mismatch_exception: null\n\tRoot causes:\n\t\tparsing_exception: line 1:15: mismatched input 'WHERE' expecting {<EOF>, '|', ',', 'metadata'}\n    at KibanaTransport._request (Desktop/Dev/kibana/node_modules/@elastic/elasticsearch/node_modules/@elastic/transport/src/Transport.ts:591:17)\n    at processTicksAndRejections (node:internal/process/task_queues:105:5)\n    at Desktop/Dev/kibana/node_modules/@elastic/elasticsearch/node_modules/@elastic/transport/src/Transport.ts:697:22\n    at KibanaTransport.request (Desktop/Dev/kibana/node_modules/@elastic/elasticsearch/node_modules/@elastic/transport/src/Transport.ts:694:14)"
    }
  }
]
```


### MCP server URL copy button omits space name

<note>
  Fixed on serverless and 9.3.
</note>

On 9.2 deployments, the **Copy your MCP server URL** button does not include the space name when used from a custom Kibana Space.
**Workaround:** Manually add `/s/<space-name>` to the URL. For example: `https://<deployment>/s/<space-name>/api/agent_builder/mcp`
For more information about Elastic Agent Builder and Spaces, refer to [Permissions and access control](/docs/explore-analyze/ai-features/agent-builder/permissions#working-with-spaces).

## Related pages

- [Get started](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started)
- [Troubleshooting](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/troubleshooting)