﻿---
title: Get started with Elastic Agent Builder
description: Learn how to enable Elastic Agent Builder, ingest data, and start chatting with AI agents.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Get started with Elastic Agent Builder
To start using Elastic Agent Builder you need an Elasticsearch deployment. If you don't already have an Elasticsearch deployment, refer to [Get started with search](https://www.elastic.co/docs/solutions/search/get-started).
For Elastic Cloud Hosted deployments, make sure you are using the solution navigation instead of classic navigation. You can set up a new [space](https://www.elastic.co/docs/deploy-manage/manage-spaces) to use the solution nav.
<admonition title="Admonition">
  This feature requires the appropriate Elastic Stack [subscription](https://www.elastic.co/pricing) or Serverless [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

<stepper>
  <step title="Enable {{agent-builder}}">
    <applies-switch>
      <applies-item title="{ "serverless": "ga", "elasticsearch" }" applies-to="Serverless Elasticsearch projects: Generally available">
        Elastic Agent Builder is enabled by default in serverless Elasticsearch projects.Find **Agents** in the navigation menu to begin using the feature, or search for **Agents** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
      </applies-item>

      <applies-item title="{ "serverless": "preview", "observability" }" applies-to="Serverless Observability projects: Generally available">
        In Elastic Observability projects, you must [switch from AI Assistant to Agent Builder](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences) to enable the feature.Once enabled, find **Agents** in the navigation menu to begin using the feature, or search for **Agents** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
      </applies-item>

      <applies-item title="{ "serverless": "preview", "security" }" applies-to="Serverless Security projects: Generally available">
        In Elastic Security projects, you must [switch from AI Assistant to Agent Builder](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences) to enable the feature.Once enabled, find **Agents** in the navigation menu to begin using the feature, or search for **Agents** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
      </applies-item>

      <applies-item title="stack: preview =9.2, ga 9.3+" applies-to="Elastic Stack: Generally available since 9.3, Elastic Stack: Preview in 9.2">
        On non-serverless deployments, Elastic Agent Builder availability depends on the navigation mode of your Kibana space:
        - **Elasticsearch solution view**: Elastic Agent Builder is enabled by default and appears in the side navigation. It replaces Search Assistant.
        - **Elastic Observability and Elastic Security solution views**: You must [switch from AI Assistant to Agent Builder](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences) to enable the feature.
        - **Classic view**: Elastic Agent Builder appears in the side navigation under Elasticsearch. You can choose Agent Builder as your assistant through the initial selector or the [chat experience switch](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences).
        Find **Agents** in the navigation menu to begin using the feature, or search for **Agents** in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
      </applies-item>
    </applies-switch>

    <note>
      To learn about required privileges for Elastic Agent Builder, refer to [Permissions and access control](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/permissions).
    </note>
  </step>

  <step title="Ingest data into Elasticsearch">
    Before you begin with agents, you need some data in Elasticsearch. Otherwise, you will be chatting to the underlying LLM without any retrieval-augmented context.To learn about adding data for search use cases, go to [Ingest for search use cases](https://www.elastic.co/docs/solutions/search/ingest-for-search).
    For a broader overview of ingestion options, go to [Ingest: Bring your data to Elastic](https://www.elastic.co/docs/manage-data/ingest).
    <tip>
      If you're not ready to add your own data, you can:
      - Use the Elastic [sample data](https://www.elastic.co/docs/manage-data/ingest/sample-data).
      - Generate synthetic financial data using [this Python tool](https://github.com/jeffvestal/synthetic-financial-data?tab=readme-ov-file#synthetic-financial-data-generator-).  (This requires your [Elasticsearch URL and an API key](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-connection-details)).
    </tip>
  </step>

  <step title="Start a conversation">
    The **Agent Chat** UI provides a conversational interface where you can interact with agents and explore your data using natural language. Elastic Agent Builder includes a default agent named `Elastic AI Agent` with access to all built-in tools, so you can begin chatting immediately.Learn more in [Agent Chat](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat).
  </step>

  <step title="Configure model (optional)">
    On Elastic Cloud Hosted and Elastic Cloud Serverless, Elastic Agent Builder comes with preconfigured models ready to use. To switch models or add your own, refer to [model selection and configuration](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/models).
  </step>

  <step title="Begin building agents and tools">
    Once you've tested [built-in agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference) with [built-in Elastic tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools), you can begin [building your own agents](/docs/explore-analyze/ai-features/agent-builder/custom-agents#create-a-new-agent) with custom instructions and [creating your own tools](/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools#create-custom-tools-in-the-ui) to assign them.
  </step>
</stepper>