﻿---
title: Chat with Elastic Agent Builder agents
description: Learn how to chat with AI agents in Agent Builder, inspect reasoning steps, and manage conversation history through the UI or API.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Chat with Elastic Agent Builder agents
**Agent Chat** is the chat interface for natural language conversations with your [agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agent-builder-agents).
The chat GUI and programmatic interfaces enable real-time communication where you can ask questions, request data analysis, and receive immediate responses from your configured agents.
<note>
  The chat UI is available in both standalone and flyout modes. For more information, refer to [Chat UI modes](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/standalone-and-flyout-modes).
</note>


## Get started

<tip>
  Refer to the [getting started](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started) guide if you need to enable the feature and ingest some data.
</tip>

Find **Agents** in the navigation menu to begin chatting.
You can also search for **Agent Builder** in the [global search bar](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
This takes you to the chat GUI:
![Annotated screenshot of the Agent Chat GUI with numbered callouts highlighting the chat input (1), agent selector (2), model selector (3), conversations panel (4), and more actions menu (5)](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agent-builder-chat-UI-get-started.png)

1. [Chat input area](#start-a-chat-and-select-an-agent)
2. [Agent selector](#select-a-different-agent)
3. [Model selector](#select-a-different-model)
4. [Conversation history](#find-conversation-history)
5. [Key actions menu](#access-key-actions)


## Agent Chat GUI


### Start a chat and select an agent

Use the text input area to chat with an agent in real time. By default, you chat with the built-in Elastic AI Agent.
![Text input area for chatting with agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agent-builder-chat-input.png)

<note>
  Conversations with agents consume tokens. To understand how usage is calculated, refer to [Token usage in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage).
</note>


#### Select a different agent

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Use the agent selector to switch agents, to navigate to the agent management section, or to create a new agent. An agent's behavior is defined by its custom instructions and available tools. Switch agents when you need different capabilities for your tasks.
![Agent selector dropdown and message input field](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agent-builder-agent-selector.png)


#### Select a different model

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Use the model selector to switch the underlying [model](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/models) the agent uses to generate responses. Switch models to prioritize faster responses, lower costs, or more complex reasoning, depending on your use case.
![Image description](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/model-selector.png)


### Access key actions

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

This menu is your hub for key management actions. You can quickly access important pages from here.
![More actions menu button](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/more-actions.png)

This opens a panel with links to key actions and management pages including agent, tool, and settings management.
![The expanded more options menu panel](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/more-actions-menu-options.png)


### Find conversation history

Use the chat history panel to access previous conversations.
![Chat history panel showing conversation list](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/agent-builder-chat-history.png)


### Inspect tool calls and reasoning

Expand the **Reasoning** section to see how the agent handles your request. This provides a detailed breakdown of the agent's reasoning steps, the tool calls it makes, and the responses it receives. The agent runs tools in a loop until it achieves its goal or [exceeds the maximum conversation length](/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues#conversation-length-exceeded).
![Reasoning panel showing tool calls and execution steps](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/reasoning-steps.png)

Select **Inspect response** to view detailed information about individual tool calls and responses.
Select **View JSON** to view the full raw response data. For more information, refer to [Monitor token usage](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage).

## Agent Chat API

The Agent Chat API provides programmatic access to chat functionality through REST endpoints.

### Quick overview

For a quick overview of the REST API for conversations, refer to [Chat and conversations API](/docs/explore-analyze/ai-features/agent-builder/kibana-api#chat-and-conversations).

### API reference

For the complete API reference, refer to the [Kibana API reference](https://www.elastic.co/docs/api/doc/kibana/operation/operation-get-agent-builder-conversations).