﻿---
title: Elastic Agent Builder built-in agents reference
description: Reference of the pre-configured AI agents available in Elastic Agent Builder, including their specialized capabilities and assigned tools.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Elastic Agent Builder built-in agents reference
This page lists the built-in agents available in Elastic Agent Builder. Built-in agents are pre-configured by Elastic with specific instructions and tools to handle common use cases.
You cannot modify or delete built-in agents. To customize one, you can clone it and [create a custom agent](/docs/explore-analyze/ai-features/agent-builder/custom-agents#create-a-new-agent).

## Availability

The availability of specific agents depends on your solution view or serverless project type.
<note>
  Elastic Observability and Elastic Security users must opt-in to use Elastic Agent Builder. To learn more, refer to [Compare Agent Builder and AI Assistant > Switch between chat experiences](/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant#switch-between-chat-experiences).
</note>


## Elastic AI Agent

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
  - Elastic Stack: Preview in 9.2
</applies-to>

The **Elastic AI Agent** is the default general-purpose agent for Elasticsearch. It is designed to help with a wide range of tasks, from writing ES|QL queries to exploring your data indices.
**Assigned tools:**
- All [**Platform core tools**](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#platform-core-tools)


## Observability Agent

<applies-to>
  - Serverless Observability projects: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

A specialized agent for logs, metrics, and traces. It is designed to assist with infrastructure monitoring and application performance troubleshooting.
**Assigned tools:**
- All [**Observability tools**](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#observability-tools)
- All [**Platform core tools**](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#platform-core-tools)


## Threat Hunting Agent

<applies-to>
  - Serverless Security projects: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

A specialized agent for security alert analysis tasks, including alert investigation and Elastic Security documentation. It helps analysts triage alerts and understand complex security events. For more information and example use-cases, refer to [Agent Builder for Elastic Security](https://www.elastic.co/docs/solutions/security/ai/agent-builder/agent-builder).
**Assigned tools:**
- All [**Security tools**](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#security-tools)
- All [**Platform core tools**](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#platform-core-tools)


## Related pages

- [Agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agent-builder-agents)
- [Create a custom agent](/docs/explore-analyze/ai-features/agent-builder/custom-agents#create-a-new-agent)
- [Built-in tools reference](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference)