﻿---
title: Elastic Agent Builder agents overview
description: Learn how Agent Builder agents use tools to solve problems. Compare built-in and custom agents and understand the iterative reasoning loop.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/agent-builder-agents
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Elastic Agent Builder agents overview
Agents are AI models (LLMs) defined with custom instructions and a set of assigned [tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools). Users [chat](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/chat) with agents using natural language, in the Agent Builder UI or programmatically.
An agent parses user requests to define a goal and then runs tools in a loop to achieve that goal. The agent provides responses based on its configured tools, instructions, and behavior settings.

## How agents work

When you ask a question to an agent, it analyzes your request to define a specific goal. It selects the most appropriate tools and determines the right arguments to use. The agent evaluates the information returned after each action and decides whether to use additional tools or formulate a response. This iterative process of tool selection, execution, and analysis continues until the agent can provide a complete answer.
<note>
  The process of tool selection, execution, and analysis consumes tokens. To understand how usage is calculated, refer to [Token usage in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/monitor-usage).
</note>

Elastic Agent Builder includes a default agent (named `Elastic AI Agent`) with access to all built-in tools. You can [create custom agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/custom-agents) with custom instructions and selected tools to address specific use cases or workflows.
You can also use pre-configured [built-in agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference) that are specialized for common use cases.

## Built-in agents

Elastic Agent Builder includes pre-configured built-in agents optimized for common use cases:
- **[Elastic AI Agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#elastic-ai-agent)**: The default general-purpose agent with access to all platform core tools
- **[Observability Agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#observability-agent)**: Specialized for logs, metrics, and traces
- **[Threat Hunting Agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#threat-hunting-agent)**: Specialized for security alert analysis

Built-in agents cannot be modified or deleted. To customize one, you can clone it and create a custom agent.
For the complete list of built-in agents and their assigned tools, refer to [Built-in agents reference](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference).

## Custom agents

Create custom agents tailored to your specific needs by defining custom instructions and selecting relevant tools. Custom agents give you full control over:
- Agent behavior and personality through custom instructions
- Available tools and capabilities
- Visual appearance and organization

To learn how to create and manage custom agents, refer to [Custom agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/custom-agents).

## Managing agents in the UI

The **Agents** page provides a centralized view of all your agents. From this page you can:
- View all your agents with their names and labels
- Search for specific agents using the search bar
- Filter agents by labels using the **Labels** dropdown
- Create new agents using the **New agent** button
- Start chatting with an agent or perform other actions:
  - **Built-in agents**: You can **chat** or **clone** built-in agents. They cannot be edited or deleted.
  ![Chat with agent and clone agent buttons](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/chat-and-clone-buttons.png)
- **Custom agents**: You can **chat**, **edit**, **clone**, or **delete** custom agents.
  ![Agent context menu showing Chat, Edit, Clone, and Delete options](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/images/chat-edit-clone-delete.png)


## Agents API

The Agents API enables programmatic management of both built-in and custom agents.

### Quick overview

For an overview, refer to [Agents API](/docs/explore-analyze/ai-features/agent-builder/kibana-api#agents-apis).

### API reference

For the complete API reference, refer to the [Kibana API reference](https://www.elastic.co/docs/api/doc/kibana/operation/operation-get-agent-builder-agents).

## Related pages

- [Custom agents](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/custom-agents)
- [Best practices for prompt engineering in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/prompt-engineering)
- [Built-in agents reference](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference)
- [Tools](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools)