﻿---
title: Agent-to-Agent (A2A) server in Elastic Agent Builder
description: Learn how to interact with Agent Builder agents from external clients using A2A protocol endpoints and API key authentication.
url: https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/a2a-server
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Security
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3, Preview in 9.2
---

# Agent-to-Agent (A2A) server in Elastic Agent Builder
The [**Agent-to-Agent (A2A) server**](https://github.com/a2aproject/A2A) enables external A2A clients to communicate with Elastic Agent Builder agents.
<note>
  Streaming operations are not currently supported. Refer to [Limitations and known issues](/docs/explore-analyze/ai-features/agent-builder/limitations-known-issues#a2a-streaming-not-supported) for more information.
</note>


## Retrieve agent metadata (GET)

Returns metadata for a specific agent. The `agentId` is a path parameter that corresponds to your agent IDs:
```
GET /api/agent_builder/a2a/{agentId}.json
```


## Execute A2A protocol (POST)

Interact with agents following the A2A protocol specification:
```
POST /api/agent_builder/a2a/{agentId}
```

<important>
  Both A2A endpoints require API key authentication. For more information about the A2A protocol, refer to the [A2A protocol specification](https://a2aprotocol.ai/docs/guide/a2a-protocol-specification-python#protocol-flow-diagram).
</important>