﻿---
title: Serverless project custom roles
description: Built-in organization-level roles and cloud resource access roles are great for getting started with Elastic Cloud Serverless, and for system administrators...
url: https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Serverless project custom roles
Built-in [organization-level roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_organization_level_roles) and [cloud resource access roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_instance_access_roles) are great for getting started with Elastic Cloud Serverless, and for system administrators who do not need more restrictive access.
As an administrator, you can also create roles for users with the access they need within specific projects. For example, you might create a `marketing_user` role, which you then assign to all users in your marketing department. This role would grant access to all of the necessary data and features for this team to be successful, without granting them access they don’t require.
All custom roles grant the same access as the `Viewer` cloud resource access role with regards to Elastic Cloud privileges. To grant more Elastic Cloud privileges, assign more roles. Users receive a union of all their roles' privileges.
Roles are a collection of privileges that enable users to access project features and data. When you create a custom role, you can assign Elasticsearch [cluster](#custom-roles-es-cluster-privileges) and [index](#custom-roles-es-index-privileges) privileges and [Kibana](#custom-roles-kib-privileges) privileges.
On this page, you'll learn about how to [manage custom roles in your project](#manage-custom-roles), the types of privileges you can assign, and how to [assign the roles](#assign-custom-roles) that you create.
<note>
  You cannot assign [run as privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#_run_as_privilege) in Elastic Cloud Serverless custom roles.
</note>

<admonition title="Custom roles in Elastic Stack">
  This topic explains how to create custom roles in Elastic Cloud Serverless. You can also create custom roles for Elastic Stack clusters and deployments.[Learn more](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).
</admonition>


## Manage custom roles

You can manage custom roles from within your project, in **Project settings > Management > Custom Roles**. To create a new custom role, click the **Create role** button. To clone, delete, or edit a role, open the actions menu `⋯`.

## Elasticsearch cluster privileges

Cluster privileges grant access to monitoring and management features in Elasticsearch. They also enable some stack management capabilities in your project.
![Create a custom role and define Elasticsearch cluster privileges](https://www.elastic.co/docs/deploy-manage/images/serverless-custom-roles-cluster-privileges.png)

Refer to [cluster privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) for a complete description of available options.

## Elasticsearch index privileges

Each role can grant access to multiple data indices, and each index can have a different set of privileges. Typically, you will grant the `read` and `view_index_metadata` privileges to each index that you expect your users to work with. For example, grant access to indices that match an `acme-marketing-*` pattern:
![Create a custom role and define Elasticsearch index privileges](https://www.elastic.co/docs/deploy-manage/images/serverless-custom-roles-index-privileges.png)

Refer to [index privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices) for a complete description of available options.

### Document level and field level security

Document-level and field-level security affords you even more granularity when it comes to granting access to your data:
- With document-level security (DLS), you can write an Elasticsearch query to describe which documents this role grants access to. Add your query in the **Granted documents query** field using [QueryDSL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl) syntax.
  For example, the following query grants read access only to the documents whose `department_id` equals `12`:
  ```json
  {
    "term" : { "department_id" : 12 }
  }
  ```
- With field-level security (FLS), you can instruct Elasticsearch to grant or deny access to specific fields within each document. List these fields in the **Granted fields** field.

<tip>
  Elastic Cloud Serverless and Elastic Stack both use queries to specify the documents that a role can access. For additional query examples, refer to [Controlling access at the document and field level](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level#document-level-security).
</tip>


## Kibana privileges

When you create a custom role, click **Add Kibana privilege** to grant access to specific features. The features that are available vary depending on the project type. For example, in Elasticsearch Serverless:
![Create a custom role and define Kibana privileges](https://www.elastic.co/docs/deploy-manage/images/serverless-custom-roles-kibana-privileges.png)

Open the **Spaces** selection control to specify whether to grant the role access to all spaces or one or more individual spaces. When using the **Customize by feature** option, you can choose either **All**, **Read** or **None** for access to each feature.
<definitions>
  <definition term="All">
    Grants full read-write access.
  </definition>
  <definition term="Read">
    Grants read-only access.
  </definition>
  <definition term="None">
    Does not grant any access.
  </definition>
</definitions>

Some features have finer access control and you can optionally enable sub-feature privileges.
<admonition title="New features">
  As new features are added to Elastic Cloud Serverless, roles that use the custom option do not automatically get access to the new features. You must manually update the roles.
</admonition>


## Assign custom roles

After your roles are set up, the next step to securing access is to assign roles to your users. Click the **Assign roles** link to go to the **Members** tab of the **Organization** page. Learn more in [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).