﻿---
title: User roles
description: After a user is authenticated, Elastic Stack needs to determine whether the user behind an incoming request is allowed to execute the request. The primary...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# User roles
After a user is [authenticated](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication), Elastic Stack needs to determine whether the user behind an incoming request is allowed to execute the request. The primary method of authorization in a cluster is [role-based access control](#roles) (RBAC), although Elastic Stack also supports [Attribute-based access control](#attributes) (ABAC).
<tip>
  If you use Elastic Cloud Enterprise or Elastic Cloud Hosted, then you can also implement RBAC at the level of your [Elastic Cloud Enterprise orchestrator](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator) or [Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization).If you use Elastic Cloud Serverless, then you can only manage RBAC at the [Elastic Cloud organization level](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization).You must authenticate users at the same level where you implement RBAC. For example, if you want to use organization-level roles, than you must authenticate your users at the organization level.
</tip>


## How role-based access control works

Role-based access control (RBAC) enables you to authorize users by assigning privileges to roles and assigning roles to users or groups. This is the primary way of controlling access to resources in Elastic Stack.

![This image illustrates role-based access control](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-authorization.png)

The authorization process revolves around the following constructs:
<definitions>
  <definition term="Secured Resource">
    A resource to which access is restricted. Indices, aliases, documents, fields, users, and the Elasticsearch cluster itself are all examples of secured objects.
  </definition>
  <definition term="Privilege">
    A named group of one or more actions that a user may execute against a secured resource. Each secured resource has its own sets of available privileges. For example, `read` is an index privilege that represents all actions that enable reading the indexed/stored data. For a complete list of available privileges, see [Elasticsearch privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges).
  </definition>
  <definition term="Permissions">
    A set of one or more privileges against a secured resource. Permissions can easily be described in words, here are few examples:
    - `read` privilege on the `products` data stream or index
    - `manage` privilege on the cluster
    - `run_as` privilege on `john` user
    - `read` privilege on documents that match query X
    - `read` privilege on `credit_card` field
  </definition>
  <definition term="Role">
    A named set of permissions
  </definition>
  <definition term="User">
    The authenticated user.
  </definition>
  <definition term="Group">
    One or more groups to which a user belongs. Groups are not supported in some realms, such as native, file, or PKI realms.
  </definition>
</definitions>

A role has a unique name and identifies a set of permissions that translate to privileges on resources. You can associate a user or group with an arbitrary number of roles. When you map roles to groups, the roles of a user in that group are the combination of the roles assigned to that group and the roles assigned to that user. Likewise, the total set of permissions that a user has is defined by the union of the permissions in all its roles.

## Set up user authorization using RBAC

Review these topics to learn how to configure RBAC in your cluster or deployment:
- Learn about [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles)
- [Define your own roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles)
- Learn about the [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) and [Elasticsearch](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) privileges you can assign to roles
- Learn how to [control access at the document and field level](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level)

<tip>
  This topic describes built-in roles in Elastic Stack clusters and deployments and explains how to create custom ones. You can also learn about [organization-level](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_organization_level_roles) roles and [cloud resource access roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_instance_access_roles) in Elastic Cloud Serverless.
  To create custom roles for Elastic Cloud Serverless, refer to [Serverless project custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles).
</tip>

<admonition title="Control access at the document and field level in Serverless">
  Elastic Cloud Serverless centralizes user management with [Cloud organization-level roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_organization_level_roles). You can configure [document- and field-level access control](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) in Elastic Cloud Serverless projects as a part of a project-level custom role.
</admonition>


### Assign roles to users

The way that you assign roles to users depends on your authentication realm:
- [Native realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native):
  - Using Elasticsearch API [`_security` endpoints](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-security)
- [In Kibana](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native#managing-native-users), from the **Users** management page. Find the page in the navigation menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
- [File realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based):
  - Using a [`user_roles` file](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based#k8s-basic)
- In ECK: As part of a [basic authentication secret](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based#k8s-basic)
- [External realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/external-authentication): By [mapping users and groups to roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles)

<tip>
  This topic describes using the native realm at the cluster or deployment level, for the purposes of authenticating with Elasticsearch and Kibana.You can also manage authentication and identity integration at the [Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/manage-users) level.
</tip>


### Advanced topics

- Learn how to [delegate authorization to another realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authorization-delegation)
- Learn how to [build a custom authorization plugin](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authorization-plugins) for unsupported systems or advanced applications
- Learn how to [submit requests on behalf of other users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users)
- Learn about [attribute-based access control](#attributes)

<tip>
  User roles are also used to control access to [Kibana spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces).
</tip>


## Attribute-based access control

Attribute-based access control (ABAC) enables you to use attributes to restrict access to documents in search queries and aggregations. For example, you can assign attributes to users and documents, then implement an access policy in a role definition. Users with that role can read a specific document only if they have all the required attributes.
For more information, see [Document-level attribute-based access control with Elasticsearch](https://www.elastic.co/blog/attribute-based-access-control-elasticsearch).