﻿---
title: User authentication
description: Authentication identifies an individual. To gain access to restricted resources, a user must prove their identity, using passwords, credentials, or some...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication
products:
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# User authentication
Authentication identifies an individual. To gain access to restricted resources, a user must prove their identity, using passwords, credentials, or some other means (typically referred to as authentication tokens).
The Elastic Stack authenticates users by identifying the users behind the requests that hit the cluster and verifying that they are who they claim to be. The authentication process is handled by one or more authentication services called [*realms*](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms).
You can manage and authenticate users natively, or integrate with external user management systems such as LDAP and Active Directory. If none of the built-in realms meet your needs, you can also build your own custom realm and plug it into the Elastic Stack.
When security features are enabled, depending on the realms you’ve configured, you must attach your user credentials to requests sent to Elasticsearch. For example, when using realms that support usernames and passwords, you can attach a [basic auth](https://en.wikipedia.org/wiki/Basic_access_authentication) header to the requests.
The security features provide two services: the token service and the API key service. You can use these services to exchange the current authentication for a token or key. This token or key can then be used as credentials for authenticating new requests. The API key service is enabled by default. The token service is enabled by default when TLS/SSL is enabled for HTTP.
Review the following topics to learn about authentication in your Elasticsearch cluster.
<tip>
  If you use Elastic Cloud Enterprise or Elastic Cloud Hosted, then you can also manage authentication at the level of your [Elastic Cloud Enterprise orchestrator](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator) or [Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization).If you use Elastic Cloud Serverless, then you can only manage authentication at the [Elastic Cloud organization level](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization).
</tip>


### Set up user authentication

- Set up an authentication method:
  - Learn about the available [realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms) that you can use to authenticate users.
- Manage passwords for [default users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
- Manage users using [internal realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/internal-authentication):
  - Manage users [natively](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native)
- Configure [file-based authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based)
- Integrate with external authentication providers using [external realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/external-authentication):
  - [Active Directory](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/active-directory)
- [JWT](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/jwt)
- [Kerberos](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kerberos)
- [LDAP](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap)
- [OpenID Connect](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect)
- [SAML](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml)
- [PKI](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/pki)
- [Implement a custom realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/custom)
- Configure [authentication mechanisms for Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication).
- Enable [anonymous access](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/anonymous-access).
- Set up a [user access agreement](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/access-agreement).


### Advanced topics

- Learn about [internal users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/internal-users), which are responsible for the operations that take place inside an Elasticsearch cluster.
- Learn about [service accounts](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/service-accounts), which are used for integration with external services that connect to Elasticsearch.
- Learn about the [services used for token-based authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/token-based-authentication-services).
- Learn about the [services used by orchestrators](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-privileges).
- Manage [user profiles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-profiles).
- Learn about [user lookup technologies](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/looking-up-users-without-authentication).
- [Manage the user cache](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-user-cache).
- Manage authentication for [multiple clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/manage-authentication-for-multiple-clusters) using Elastic Stack configuration policies (Elastic Cloud on Kubernetes only)