﻿---
title: Token-based authentication services
description: The Elastic Stack security features authenticate users by using realms and one or more token-based authentication services. The token-based authentication...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/token-based-authentication-services
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Token-based authentication services
The Elastic Stack security features authenticate users by using realms and one or more token-based authentication services. The token-based authentication services are used for authenticating and managing tokens. You can attach these tokens to requests that are sent to Elasticsearch and use them as credentials. When Elasticsearch receives a request that must be authenticated, it consults the token-based authentication services first, and then the realm chain.
The security features provide the following built-in token-based authentication services, which are listed in the order they are consulted:
<definitions>
  <definition term="service-accounts">
    The [service accounts](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/service-accounts) use either the [create service account token API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-service-token) or the [elasticsearch-service-tokens](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/service-tokens-command) CLI tool to generate service account tokens.
  </definition>
</definitions>

To use a service account token, include the generated token value in a request with an `Authorization: Bearer` header:
```shell
curl -H "Authorization: Bearer AAEAAWVsYXN0aWMvZ...mXQtc2VydmMTpyNXdkYmRib1FTZTl2R09Ld2FKR0F3" http://localhost:9200/_cluster/health
```

<important>
  Do not attempt to use service accounts for authenticating individual users. Service accounts can only be authenticated with service tokens, which are not applicable to regular users.
</important>


<definitions>
  <definition term="token-service">
    The token service uses the [get token API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-token) to generate access tokens and refresh tokens based on the OAuth2 specification. The access token is a short-lived token. By default, it expires after 20 minutes but it can be configured to last a maximum of 1 hour. It can be refreshed by using a refresh token, which has a lifetime of 24 hours. The access token is a bearer token. You can use it by sending a request with an `Authorization` header with a value that has the prefix "Bearer " followed by the value of the access token. For example:
    ```shell
    curl -H "Authorization: Bearer dGhpcyBpcyBub3Qx5...F0YS4gZG8gbm90IHRyeSB0byByZWFkIHRva2VuIQ==" http://localhost:9200/_cluster/health
    ```
  </definition>
</definitions>


<definitions>
  <definition term="api-key-service">
    The API key service uses the [create API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key) to generate API keys. By default, the API keys do not expire. When you make a request to create API keys, you can specify an expiration and permissions for the API key. The permissions are limited by the authenticated user’s permissions. You can use the API key by sending a request with an `Authorization` header with a value that has the prefix "ApiKey " followed by the credentials. The credentials are the base64 encoding of the API key ID and the API key joined by a colon. For example:
    ```shell
    curl -H "Authorization: ApiKey VnVhQ2ZHY0JDZGJrU...W0tZTVhT3g6dWkybHAyYXhUTm1zeWFrd0dk5udw==" http://localhost:9200/_cluster/health
    ```
  </definition>
</definitions>

Depending on your use case, you may want to decide on the lifetime of the tokens generated by these services. You can then use this information to decide which service to use to generate and manage the tokens. Non-expiring API keys may seem like the easy option but you must consider the security implications that come with non-expiring keys. Both the *token-service* and *api-key-service* permit you to invalidate the tokens. See [invalidate token API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-token) and [invalidate API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-api-key).
<important>
  Authentication support for JWT bearer tokens was introduced in Elasticsearch 8.2 through the [JWT authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/jwt), which cannot be enabled through token-authentication services. Realms offer flexible order and configurations of zero, one, or multiple JWT realms.
</important>