﻿---
title: Role structure
description: A role is defined by the following JSON structure: The following describes the structure of an indices permissions entry: The following describes the...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/role-structure
applies_to:
  - Elastic Stack: Generally available
---

# Role structure
A role is defined by the following JSON structure:
```js
{
  "run_as": [ ... ], 
  "cluster": [ ... ], 
  "global": { ... }, 
  "indices": [ ... ], 
  "applications": [ ... ], 
  "remote_indices": [ ... ], 
  "remote_cluster": [ ... ], 
  "metadata": { ... }, 
  "description": "..." 
}
```

<note>
  Role names must be at least 1 and no more than 507 characters. They can contain alphanumeric characters (`a-z`, `A-Z`, `0-9`), spaces, punctuation, and printable symbols in the [Basic Latin (ASCII) block](https://en.wikipedia.org/wiki/Basic_Latin_(Unicode_block)). Leading or trailing whitespace is not allowed.
</note>


## Indices privileges

The following describes the structure of an indices permissions entry:
```js
{
  "names": [ ... ], 
  "privileges": [ ... ], 
  "field_security" : { ... }, 
  "query": "...", 
  "allow_restricted_indices": false 
}
```

<admonition title="Using wildcards and regex">
  The `names` parameter accepts wildcard and regular expressions that may refer to multiple data streams, indices, and aliases.
  - Wildcard (default): Simple wildcard matching where `*` is a placeholder for zero or more characters, `?` is a placeholder for a single character and `\` may be used as an escape character.
  - Regular Expressions: A more powerful syntax for matching more complex patterns. This regular expression is based on Lucene’s regexp automaton syntax. To enable this syntax, it must be wrapped within a pair of forward slashes (`/`). Any pattern starting with `/` and not ending with `/` is considered to be malformed.

  ```js
  "foo-bar": 
  "foo-*": 
  "logstash-201?-*": 
  "/.*-201[0-9]-.*/": 
  "/foo": 
  ```
</admonition>


## Global privileges

The following describes the structure of the global privileges entry:
```js
{
  "application": {
    "manage": {    
      "applications": [ ... ] 
    }
  },
  "profile": {
    "write": { 
      "applications": [ ... ] 
    }
  }
}
```


## Application privileges

The following describes the structure of an application privileges entry:
```js
{
  "application": "my_app", 
  "privileges": [ ... ],   
  "resources": [ ... ]     
}
```

For details about the validation rules for these fields, see the [add application privileges API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-put-privileges).
A role may refer to application privileges that do not exist - that is, they have not yet been defined through the add application privileges API (or they were defined, but have since been deleted). In this case, the privilege has no effect, and will not grant any actions in the [has privileges API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-has-privileges).

## Remote indices privileges

For [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key), remote indices privileges can be used to specify desired indices privileges for matching remote clusters. The final effective index privileges will be an intersection of the remote indices privileges and the [cross-cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key)'s indices privileges.
<note>
  Remote indices are effective for remote clusters configured with the API key based model. They have no effect for remote clusters configured with the certificate based model.
</note>

The remote indices privileges entry has an extra mandatory `clusters` field compared to an [indices privileges entry](#roles-indices-priv). Otherwise the two have identical structure. The following describes the structure of a remote indices permissions entry:
```js
{
  "clusters": [ ... ], 
  "names": [ ... ], 
  "privileges": [ ... ], 
  "field_security" : { ... }, 
  "query": "...", 
  "allow_restricted_indices": false 
}
```


## Remote cluster privileges

For [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key), remote cluster privileges can be used to specify additional cluster privileges for matching remote clusters.
<note>
  Remote cluster privileges are only effective for remote clusters configured with the API key based model. They have no effect on remote clusters configured with the certificate based model.
</note>

The following describes the structure of a remote cluster permissions entry:
```js
{
  "clusters": [ ... ], 
  "privileges": [ ... ] 
}
```


## Example

The following snippet shows an example definition of a `clicks_admin` role:
```json

{
  "run_as": [ "clicks_watcher_1" ],
  "cluster": [ "monitor" ],
  "indices": [
    {
      "names": [ "events-*" ],
      "privileges": [ "read" ],
      "field_security" : {
        "grant" : [ "category", "@timestamp", "message" ]
      },
      "query": "{\"match\": {\"category\": \"click\"}}"
    }
  ]
}
```

Based on the above definition, users owning the `clicks_admin` role can:
- Impersonate the `clicks_watcher_1` user and execute requests on its behalf.
- Monitor the Elasticsearch cluster
- Read data from all indices prefixed with `events-`
- Within these indices, only read the events of the `click` category
- Within these document, only read the `category`, `@timestamp` and `message` fields.

<tip>
  View a complete list of available [cluster and indices privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges).
</tip>