﻿---
title: Role restriction
description: Role restriction can be used to specify conditions under which a role should be effective. When conditions are not met, the role will be disabled, which...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/role-restriction
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Role restriction
Role restriction can be used to specify conditions under which a role should be effective. When conditions are not met, the role will be disabled, which will result in access being denied. Not specifying restriction means the role is not restricted and thus always effective. This is the default behavior.
Currently, the role restriction is only supported for [API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), with limitation that the API key can only have a single role descriptor.

## Workflows

Workflows allow to restrict the role to be effective exclusively when calling certain REST APIs. Calling a REST API that is not allowed by a workflow, will result in the role being disabled. The below section lists workflows that you can restrict the role to:
<definitions>
  <definition term="search_application_query">
    This workflow restricts the role to the [Search Application Search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search-application-search) only.
  </definition>
</definitions>

<note>
  Workflow names are case-sensitive.
</note>


### Examples

The following example creates an API key with a restriction to the `search_application_query` workflow, which allows to call only [Search Application Search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search-application-search):
```json

{
  "name": "my-restricted-api-key",
  "role_descriptors": {
    "my-restricted-role-descriptor": {
      "indices": [
        {
          "names": ["my-search-app"],
          "privileges": ["read"]
        }
      ],
      "restriction":  {
        "workflows": ["search_application_query"]
      }
    }
  }
}
```