﻿---
title: Quickstart: Native Elasticsearch user and role management
description: If you plan to use native Elasticsearch user and role management, then you can manage your users and roles completely within your Kibana instance. You...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/quickstart
products:
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# Quickstart: Native Elasticsearch user and role management
If you plan to use native Elasticsearch user and role management, then you can manage your users and roles completely within your Kibana instance.
You can use native access management features to give your users access to only the surfaces and features they need. For example, some users might only need to view your dashboards, while others might need to manage your fleet of Elastic agents and run machine learning jobs to detect anomalous behavior in your network.
This guide introduces you to three basic user and access management features: [spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces), [roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles), and [native users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native). By the end of this tutorial, you will learn how to manage these entities, and how you can leverage them to secure access to Elasticsearch, Kibana, and your data.

## Spaces

Do you have multiple teams using Kibana? Do you want a “playground” to experiment with new visualizations or rules? If so, then [Kibana Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) can help.
Think of a space as another instance of Kibana. A space allows you to organize your [dashboards](https://www.elastic.co/docs/explore-analyze/dashboards), [rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts), [machine learning jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana), and much more into their own categories. For example, you might have a **Marketing** space for your marketers to track the results of their campaigns, and an **Engineering** space for your developers to [monitor application performance](https://www.elastic.co/docs/solutions/observability/apm).
The assets you create in one space are isolated from other spaces, so when you enter a space, you only see the assets that belong to that space.
Refer to the [Spaces documentation](https://www.elastic.co/docs/deploy-manage/manage-spaces) for more information.

## Roles

After your spaces are set up, the next step to securing access is to provision your roles. Roles are a collection of privileges that allow you to perform actions in Kibana and Elasticsearch. Roles are assigned to users, and to [system accounts](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users) that power the Elastic Stack.
You can create your own roles, or use any of the [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles). Some built-in roles are intended for Elastic Stack components and should not be assigned to end users directly.
An example of a built-in role is `kibana_admin`. Assigning this role to your users will grant access to all of Kibana's features. This includes the ability to manage spaces.
Built-in roles are great for getting started with the Elastic Stack, and for system administrators who do not need more restrictive access. However, if you need to control access with more precision, you can create [custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).
As an administrator, you have the ability to create your own roles to describe exactly the kind of access your users should have. For example, you might create a `marketing_user` role, which you then assign to all users in your marketing department. This role would grant access to all of the necessary data and features for this team to be successful, without granting them access they don’t require.

## Users

After your roles are set up, the next step to securing access is to create your users, and assign them one or more roles. Kibana's user management allows you to provision accounts for each of your users.
<tip>
  Want Single Sign-on? Kibana supports a wide range of SSO implementations, including SAML, OIDC, LDAP/AD, and Kerberos. [Learn more about SSO options](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication).
</tip>


## Example: Create a user with access only to dashboards

Let’s work through an example together. Consider a marketing analyst who wants to monitor the effectiveness of their campaigns. They should be able to see their team’s dashboards, but not be allowed to view or manage anything else in Kibana.

### Create a space

Create a **Marketing** space for your marketing analysts to use.
1. Go to the **Spaces** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Create a space**.
3. Give this space a unique name. For example: `Marketing`.
4. Click **Create space**.
   If you’ve followed the example above, you should end up with a space that looks like this:
   ![Create space UI](https://www.elastic.co/docs/deploy-manage/images/kibana-tutorial-secure-access-example-1-space.png)


### Create a role

To effectively use dashboards, create a role that describes the privileges you want to grant. In this example, a marketing analyst will need:
- Access to **read** the data that powers the dashboards
- Access to **read** the dashboards within the `Marketing` space

To create the role:
1. Go to the **Roles** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Create role**.
3. Give this role a unique name. For example: `marketing_dashboards_role`.
4. For this example, you want to store all marketing data in the `acme-marketing-*` set of indices. To grant this access, locate the **Index privileges** section and enter:
   1. `acme-marketing-*` in the **Indices** field.
2. `read` and `view_index_metadata` in the **Privileges** field.
   <tip>
   You can add multiple patterns of indices, and grant different access levels to each. Click **Add index privilege** to grant additional access.
   </tip>
5. To grant access to dashboards in the `Marketing` space, locate the Kibana section, and click **Add Kibana privilege**:
   1. From the **Spaces** dropdown, select the `Marketing` space.
2. Expand the **Analytics** section, and select the **Read** privilege for **Dashboard**.
3. Click **Add Kibana privilege**.
6. Click **Create role**.
   If you’ve followed the example above, you should end up with a role that looks like this:
   ![Create role UI](https://www.elastic.co/docs/deploy-manage/images/kibana-tutorial-secure-access-example-1-role.png)


### Create a user

Now that you created a role, create a user account.
1. Go to the **Users** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Create user**.
3. Give this user a descriptive username, and choose a secure password.
4. Assign the **marketing_dashboards_role** that you previously created to this new user.
5. Click **Create user**.

![Create user UI](https://www.elastic.co/docs/deploy-manage/images/kibana-tutorial-secure-access-example-1-user.png)


### Verify

Verify that the user and role are working correctly.
1. Log out of Kibana if you are already logged in.
2. In the login screen, enter the username and password for the account you created.
   You’re taken into the `Marketing` space, and the main navigation shows only the **Dashboard** application.
   ![Verifying access to dashboards](https://www.elastic.co/docs/deploy-manage/images/kibana-tutorial-secure-access-example-1-test.png)


## Next steps

This guide is an introduction to basic auth features. Check out these additional resources to learn more about authenticating and authorizing your users.
- View the [authentication guide](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication) to learn more about single-sign on and other login features.
- View the [authorization guide](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) to learn more about authorizing access to Kibana's features.