﻿---
title: Orchestrator-managed users
description: The Elasticsearch provides default user credentials to help you get up and running. In self-managed clusters, these users are created as built-in users...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/orchestrator-managed-users-overview
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Orchestrator-managed users
The Elasticsearch provides default user credentials to help you get up and running.
In self-managed clusters, these users are created as [built-in users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
In orchestrated deployments (ECH, ECE, and ECK), the `elastic` user is managed by the platform, while other default users are not accessible to end users. The way that credentials are managed for this and other internal users depends on your orchestrator.
In this section, you'll learn how to manage credentials for orchestrator-managed users:
- In Elastic Cloud Enterprise and Elastic Cloud Hosted, [learn how to reset password for the `elastic` user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/manage-elastic-user-cloud).
- In Elastic Cloud on Kubernetes, [learn how to manage the `elastic` user, and how to rotate all auto-generated credentials used by ECK](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/managed-credentials-eck).

<tip>
  To learn more about built-in users in self-managed clusters, and how to reset built-in user passwords, refer to:
  - [Built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users)
  - [Set passwords for native and built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm).
</tip>