﻿---
title: Operator privileges
description: With a typical Elasticsearch deployment, people who administer the cluster also operate the cluster at the infrastructure level. User authorization based...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-privileges
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Operator privileges
<admonition title="Indirect use only">
  This feature is designed for indirect use by Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes. Direct use is not supported.
</admonition>

With a typical Elasticsearch deployment, people who administer the cluster also operate the cluster at the infrastructure level. User authorization based on [role-based access control (RBAC)](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles) is effective and reliable for this environment. However, in more managed environments, such as [Elastic Cloud Hosted](https://cloud.elastic.co/registration?page=docs&placement=docs-body), there is a distinction between the operator of the cluster infrastructure and the administrator of the cluster.
Operator privileges limit some functionality to operator users *only*. Operator users are just regular Elasticsearch users with access to specific [operator-only functionality](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-only-functionality). These privileges are not available to cluster administrators, even if they log in as a highly privileged user such as the `elastic` user or another user with the `superuser` role. By limiting system access, operator privileges enhance the Elasticsearch security model while safeguarding user capabilities.
Operator privileges are enabled on Elastic Cloud, which means that some infrastructure management functionality is restricted and cannot be accessed by your administrative users. This capability protects your cluster from unintended infrastructure changes.