﻿---
title: Operator privileges for snapshot and restore
description: Invoking operator-only APIs or updating operator-only dynamic cluster settings typically results in changes in the cluster state. The cluster state can...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-privileges-for-snapshot-restore
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Operator privileges for snapshot and restore
<admonition title="Indirect use only">
  This feature is designed for indirect use by Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes. Direct use is not supported.
</admonition>

Invoking [operator-only APIs](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-only-functionality#operator-only-apis) or updating [operator-only dynamic cluster settings](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-only-functionality#operator-only-dynamic-cluster-settings) typically results in changes in the cluster state. The cluster state can be included in a cluster [snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore). Snapshots are a great way to preserve the data of a cluster, which can later be restored to bootstrap a new cluster, perform migration, or disaster recovery, for example. In a traditional self-managed environment, the intention is for the restore process to copy the entire cluster state over when requested. However, in a more managed environment, such as [Elastic Cloud Hosted](https://cloud.elastic.co/registration?page=docs&placement=docs-body), data that is associated with [operator-only functionality](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-only-functionality) is explicitly managed by the infrastructure code.
Restoring snapshot data associated with operator-only functionality could be problematic because:
1. A snapshot could contain incorrect values for operator-only functionalities. For example, the snapshot could have been taken in a different cluster where requirements are different or the operator privileges feature is not enabled. Restoring data associated with operator-only functionality breaks the guarantee of operator privileges.
2. Even when the infrastructure code can correct the values immediately after a restore, there will always be a short period of time when the cluster could be in an inconsistent state.
3. The infrastructure code prefers to configure operator-only functionality from a single place, that is to say, through API calls.

Therefore, [when the operator privileges feature is enabled](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/configure-operator-privileges), snapshot data that is associated with any operator-only functionality is **not** restored.
<note>
  That information is still included when taking a snapshot so that all data is always preserved.
</note>