﻿---
title: Elastic Cloud on Kubernetes managed credentials
description: When deploying an Elastic Stack application, the operator generates a set of credentials essential for the operation of that application. For example,...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/managed-credentials-eck
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Elastic Cloud on Kubernetes managed credentials
When deploying an Elastic Stack application, the operator generates a set of credentials essential for the operation of that application. For example, these generated credentials include the default `elastic` user for Elasticsearch and the security token for APM Server.
To list all auto-generated credentials in a namespace, run the following command:
```sh
kubectl get secret -l eck.k8s.elastic.co/credentials=true
```


## Default elastic user

When the Elasticsearch resource is created, a default user named `elastic` is created automatically, and is assigned the `superuser` role.
Its password can be retrieved in a Kubernetes secret, whose name is based on the Elasticsearch resource name: `<elasticsearch-name>-es-elastic-user`.
For example, the password of the `elastic` user for an Elasticsearch cluster named `quickstart` can be retrieved with:
```sh
kubectl get secret quickstart-es-elastic-user -o go-template='{{.data.elastic | base64decode}}'
```


### Disabling the default `elastic` user

If your prefer to manage all users via SSO, for example using [SAML Authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml) or OpenID Connect, you can disable the default `elastic` superuser by setting the `auth.disableElasticUser` field in the Elasticsearch resource to `true`:
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: elasticsearch-sample
spec:
  version: 9.3.0
  auth:
    disableElasticUser: true
  nodeSets:
  - name: default
    count: 1
```


## ECK auto-generated credentials

Elastic Cloud on Kubernetes auto-generates credentials for [the `elastic` user](#k8s-default-elastic-user) and other file-based users. These credentials are stored in Kubernetes Secrets and are labeled with `eck.k8s.elastic.co/credentials=true`.

### Rotate auto-generated credentials

You can force the auto-generated credentials to be regenerated with new values by deleting the appropriate Secret. For example, to change the password for the `elastic` user from the [quickstart example](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart), use the following command:
```sh
kubectl delete secret quickstart-es-elastic-user
```

<warning>
  If you are using the `elastic` user credentials in your own applications, they will fail to connect to Elasticsearch and Kibana after you run this command. It is not recommended to use `elastic` user credentials for production use cases. Always [create your own users with restricted roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native) to access Elasticsearch.
</warning>

To regenerate all auto-generated credentials in a namespace, run the following command:
<warning>
  The following command regenerates auto-generated credentials of **all** Elastic Stack applications in the namespace.
</warning>

<applies-switch>
  <applies-item title="eck: ga 3.2+" applies-to="Elastic Cloud on Kubernetes: Generally available since 3.2">
    ```sh
    kubectl delete secret -l eck.k8s.elastic.co/credentials=true
    ```
  </applies-item>

  <applies-item title="eck: ga 3.0-3.1" applies-to="Elastic Cloud on Kubernetes: Generally available from 3.0 to 3.1">
    ```sh
    kubectl delete secret -l eck.k8s.elastic.co/credentials=true,common.k8s.elastic.co/type!=kibana
    ```
  </applies-item>
</applies-switch>


### Control the length of auto-generated passwords

<applies-to>
  - Elastic Cloud on Kubernetes: Generally available since 3.2
</applies-to>

<note>
  The ability to control the length of passwords generated by Elastic Cloud on Kubernetes requires an Enterprise license.
</note>

You can control the length of auto-generated passwords in Elastic Cloud on Kubernetes installations by setting either `config.policies.passwords.length` in your Helm chart values or `password-length` in the `elastic-operator` `ConfigMap` when installing with YAML manifests. Refer to the [operator configuration documentation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configure-eck) for details on managing these settings.
Changing these values does not update existing passwords. To rotate current credentials, refer to the [Rotate auto-generated credentials](#k8s-rotate-credentials)

## Creating custom users

Elastic Cloud on Kubernetes provides functionality to facilitate custom user creation through various authentication realms. You can create users using the native realm, file realm, or external authentication methods.

### File realm

ECK supports creating users through Kubernetes secrets referenced in the Elasticsearch resource. These secrets can contain either file realm content or standard authentication credentials with a username and password.
For more information, refer to [File-based user authentication > Add users](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based#add-users), and check the ECK examples.

### Native realm

You can create custom users in the Elasticsearch native realm using Elasticsearch user management APIs or Kibana.
Refer to [Native user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native) for more details.

### External authentication realms

You can also configure external authentication realms such as LDAP, OpenID Connect, or SAML in your ECK deployments by providing the appropriate Elasticsearch or Kibana configuration settings and any required [certificates or configuration files](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/custom-configuration-files-plugins).
For more information, refer to [External authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/external-authentication).

## Creating custom roles

ECK facilitates file-based role management through Kubernetes secrets containing the roles specification. Alternatively, you can use the Role management API or the Role management UI in Kibana.
Refer to [Managing custom roles](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles#managing-custom-roles) for details and ECK based examples.