﻿---
title: Reset the elastic user password in Elastic Cloud Hosted and Elastic Cloud Enterprise
description: You might need to reset the password for the elastic superuser if you can't authenticate with the elastic user ID and are effectively locked out from...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/manage-elastic-user-cloud
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Reset the elastic user password in Elastic Cloud Hosted and Elastic Cloud Enterprise
You might need to reset the password for the `elastic` superuser if you can't authenticate with the `elastic` user ID and are effectively locked out from an Elasticsearch cluster or Kibana.
<note>
  Elastic does not manage the `elastic` user and does not have access to the account or its credentials. If you lose the password, you have to reset it.
</note>

<note>
  Resetting the `elastic` user password does not interfere with Marketplace integrations.
</note>

<note>
  The `elastic` user should be not be used unless you have no other way to access your deployment. [Create API keys for ingesting data](https://www.elastic.co/docs/reference/beats/filebeat/beats-api-keys), and create user accounts with [appropriate roles for user access](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/quickstart).
</note>

To reset the password:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body) or ECE [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the home page, find your deployment.
   <tip>
   If you have many deployments, you can instead go to the **Hosted deployments** (Elastic Cloud Hosted) or **Deployments** (Elastic Cloud Enterprise) page. On that page, you can narrow your deployments by name, ID, or choose from several other filters.
   </tip>
3. Select **Manage**.

1. Under the deployment's name in the navigation menu, select **Security**.
2. Select **Reset password**.
3. Copy down the auto-generated a password for the `elastic` user.

The password is not accessible after you close the window, so if you lose it, you need to reset the password again.