﻿---
title: Looking up users without authentication
description: Elasticsearch realms exist primarily to support user authentication. Some realms authenticate users with a password (such as the native and ldap realms),...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/looking-up-users-without-authentication
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Looking up users without authentication
Elasticsearch [realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms) exist primarily to support [user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication). Some realms authenticate users with a password (such as the [`native`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native) and [`ldap`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap) realms), and other realms use more complex authentication protocols (such as the [`saml`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml) and [`oidc`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect) realms). In each case, the *primary* purpose of the realm is to establish the identity of the user who has made a request to the Elasticsearch API.
However, some Elasticsearch features need to *look up* a user without using their credentials.
- The [`run_as`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users) feature executes requests on behalf of another user. An authenticated user with `run_as` privileges can perform requests on behalf of another unauthenticated user.
- The [delegated authorization](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/realm-chains#authorization_realms) feature links two realms together so that a user who authenticates against one realm can have the roles and metadata associated with a user from a different realm.

In each of these cases, a user must first authenticate to one realm and then Elasticsearch will query the second realm to find another user. The authenticated user credentials are used to authenticate in the first realm only, The user in the second realm is retrieved by username, without needing credentials.
When Elasticsearch resolves a user using their credentials (as performed in the first realm), it is known as *user authentication*.
When Elasticsearch resolves a user using the username only (as performed in the second realm), it is known as *user lookup*.
See the [run_as](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users) and [delegated authorization](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/realm-chains#authorization_realms) documentation to learn more about these features, including which realms and authentication methods support `run_as` or delegated authorization. In both cases, only the following realms can be used for the user lookup:
- The reserved, [`native`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native) and [`file`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based) realms always support user lookup.
- The [`ldap`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap) realm supports user lookup when the realm is configured in [*user search* mode](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap#ldap-realm-configuration). User lookup is not support when the realm is configured with `user_dn_templates`.
- User lookup support in the [`active_directory`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/active-directory) realm requires that the realm be configured with a [`bind_dn`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-ad-settings) and a bind password.

The `pki`, `saml`, `oidc`, `kerberos` and `jwt` realms do not support user lookup.
<note>
  If you want to use a realm only for user lookup and prevent users from authenticating against that realm, you can [configure the realm](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-realm-settings) and set `authentication.enabled` to `false`
</note>

The user lookup feature is an internal capability that is used to implement the `run_as` and delegated authorization features - there are no APIs for user lookup. If you want to test your user lookup configuration, then you can do this with `run_as`. Use the [Authenticate](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-authenticate) API, authenticate as a `superuser` (e.g. the builtin `elastic` user) and specify the [`es-security-runas-user` request header](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users).
<note>
  The [Get users](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-user) API and [User profiles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-profiles) feature are alternative ways to retrieve information about a Elastic Stack user. Those APIs are not related to the user lookup feature.
</note>