﻿---
title: Kibana privileges
description: Kibana privileges grant users access to features within Kibana. Roles have privileges to determine whether users have write or read access. To learn how...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges
products:
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# Kibana privileges
Kibana privileges grant users access to features within Kibana. Roles have privileges to determine whether users have write or read access.
To learn how to assign privileges to a role, refer to [Defining roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).

## Base privileges

Assigning a base privilege grants access to all Kibana features, such as **Discover**, **Dashboard**, **Visualize Library**, and **Canvas**.

<definitions>
  <definition term="all">
    Grants full read-write access.
  </definition>
  <definition term="read">
    Grants read-only access.
  </definition>
</definitions>


### Assigning base privileges

From the role management screen:
![Assign base privilege](https://www.elastic.co/docs/deploy-manage/images/kibana-assign-base-privilege.png)

Using the [role APIs](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-roles):
```js
PUT /api/security/role/my_kibana_role
{
  "elasticsearch": {
    "cluster" : [ ],
    "indices" : [ ]
  },
  "kibana": [
    {
      "base": ["all"],
      "feature": {},
      "spaces": ["marketing"]
    }
  ]
}
```


## Feature privileges

Assigning a feature privilege grants access to a specific feature.
<definitions>
  <definition term="all">
    Grants full read-write access.
  </definition>
  <definition term="read">
    Grants read-only access.
  </definition>
</definitions>


### Sub-feature privileges

Some features allow for finer access control than the `all` and `read` privileges. This additional level of control is a [subscription feature](https://www.elastic.co/subscriptions).

### Assigning feature privileges

From the role management screen:
![Assign feature privilege](https://www.elastic.co/docs/deploy-manage/images/kibana-assign-subfeature-privilege.png)

Using the [role APIs](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-roles):
```js
PUT /api/security/role/my_kibana_role
{
  "elasticsearch": {
    "cluster" : [ ],
    "indices" : [ ]
  },
  "kibana": [
    {
      "base": [],
      "feature": {
        "visualize_v2": ["all"],
        "dashboard_v2": ["read", "url_create"]
      },
      "spaces": ["marketing"]
    }
  ]
}
```