﻿---
title: Kerberos authentication
description: You can configure the Elastic Stack security features to support Kerberos V5 authentication, an industry standard protocol to authenticate users in Elasticsearch...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kerberos
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Kerberos authentication
You can configure the Elastic Stack security features to support Kerberos V5 authentication, an industry standard protocol to authenticate users in Elasticsearch and Kibana.
<note>
  You can't use the Kerberos realm to authenticate on the transport network layer.
</note>

To authenticate users with Kerberos, you need to configure a Kerberos realm and map users to roles. For more information on realm settings, see [Kerberos realm settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-kerberos-settings).

## Key concepts

There are a few terms and concepts that you’ll encounter when you’re setting up Kerberos realms:
<definitions>
  <definition term="kdc">
    Key Distribution Center. A service that issues Kerberos tickets.
  </definition>
  <definition term="principal">
    A Kerberos principal is a unique identity to which Kerberos can assign tickets. It can be used to identify a user or a service provided by a server.
    Kerberos V5 principal names are of format `primary/instance@REALM`, where `primary` is a user name.
    `instance` is an optional string that qualifies the primary and is separated by a slash(`/`) from the primary. For a user, usually it is not used; for service hosts, it is the fully qualified domain name of the host.
    `REALM` is the Kerberos realm. Usually it is the domain name in upper case. An example of a typical user principal is `user@ES.DOMAIN.LOCAL`. An example of a typical service principal is `HTTP/es.domain.local@ES.DOMAIN.LOCAL`.
  </definition>
  <definition term="realm">
    Realms define the administrative boundary within which the authentication server has authority to authenticate users and services.
  </definition>
  <definition term="keytab">
    A file that stores pairs of principals and encryption keys.
    <important>
      Anyone with read permissions to this file can use the credentials in the network to access other services so it is important to protect it with proper file permissions.
    </important>
  </definition>
  <definition term="krb5.conf">
    A file that contains Kerberos configuration information such as the default realm name, the location of Key distribution centers (KDC), realms information, mappings from domain names to Kerberos realms, and default configurations for realm session key encryption types.
  </definition>
  <definition term="ticket granting ticket (TGT)">
    A TGT is an authentication ticket generated by the Kerberos authentication server. It contains an encrypted authenticator.
  </definition>
</definitions>


## Configuring a Kerberos realm

Kerberos is used to protect services and uses a ticket-based authentication protocol to authenticate users. You can configure Elasticsearch to use the Kerberos V5 authentication protocol, which is an industry standard protocol, to authenticate users. In this scenario, clients must present Kerberos tickets for authentication.
In Kerberos, users authenticate with an authentication service and later with a ticket granting service to generate a TGT (ticket-granting ticket). This ticket is then presented to the service for authentication. Refer to your Kerberos installation documentation for more information about obtaining TGT. Elasticsearch clients must first obtain a TGT then initiate the process of authenticating with Elasticsearch.

### Prerequisites

Before you set up a Kerberos realm, you must have the Kerberos infrastructure set up in your environment.
<note>
  Kerberos requires a lot of external services to function properly, such as time synchronization between all machines and working forward and reverse DNS mappings in your domain. Refer to your Kerberos documentation for more details.
</note>

These instructions do not cover setting up and configuring your Kerberos deployment. Where examples are provided, they pertain to an MIT Kerberos V5 deployment. For more information, see [MIT Kerberos documentation](http://web.mit.edu/kerberos/www/index.html)
If you're using a self-managed cluster, then perform the following additional steps:
- Enable TLS for HTTP.
  If your Elasticsearch cluster is operating in production mode, you must configure the HTTP interface to use SSL/TLS before you can enable Kerberos authentication. For more information, see [Encrypt HTTP client communications for Elasticsearch](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-http-communication).
  This step is necessary to support Kerberos authentication through Kibana. It is not required for Kerberos authentication directly against the Elasticsearch Rest API.
  If you started Elasticsearch [with security enabled](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch), then TLS is already enabled for HTTP.
  Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes have TLS enabled by default.
- Enable the token service.
  The Elasticsearch Kerberos implementation makes use of the Elasticsearch token service. If you configure TLS on the HTTP interface, this service is automatically enabled. It can be explicitly configured by adding the following setting in your [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file:
  ```yaml
  xpack.security.authc.token.enabled: true
  ```
  This step is necessary to support Kerberos authentication through Kibana. It is not required for Kerberos authentication directly against the Elasticsearch Rest API.
  Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes have TLS enabled by default.


### Create a Kerberos realm

To configure a Kerberos realm in Elasticsearch:

#### Prepare Kerberos config files

Elasticsearch uses Java GSS framework support for Kerberos authentication. To support Kerberos authentication, Elasticsearch needs the following files:
- `krb5.conf`: The Kerberos configuration file (`krb5.conf`) provides information such as the default realm, the Key Distribution Center (KDC), and other configuration details required for Kerberos authentication. For more information, see [krb5.conf](https://web.mit.edu/kerberos/krb5-latest/doc/admin/conf_files/krb5_conf.html).
- `keytab`: A keytab is a file that stores pairs of principals and encryption keys. Elasticsearch uses the keys from the keytab to decrypt the tickets presented by the user. You must create a keytab for Elasticsearch by using the tools provided by your Kerberos implementation. For example, some tools that create keytabs are `ktpass.exe` on Windows and `kadmin` for MIT Kerberos.

The configuration requirements depend on your Kerberos setup. Refer to your Kerberos documentation to configure the `krb5.conf` file.
For more information on Java GSS, see [Java GSS Kerberos requirements](https://docs.oracle.com/javase/10/security/kerberos-requirements1.htm).

#### Configure Elasticsearch

The way that you provide Kerberos config files to Elasticsearch depends on your deployment method.
For detailed information of available realm settings, see [Kerberos realm settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-kerberos-settings).
<applies-switch>
  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    1. Configure the JVM to find the Kerberos configuration file.
       Elasticsearch uses Java GSS and JAAS Krb5LoginModule to support Kerberos authentication using a Simple and Protected GSSAPI Negotiation (SPNEGO) mechanism. When the JVM needs some configuration properties, it tries to find those values by locating and loading the `krb5.conf` file. The JVM system property to configure the file path is `java.security.krb5.conf`. To configure JVM system properties see [Set JVM options](https://www.elastic.co/docs/reference/elasticsearch/jvm-settings#set-jvm-options). If this system property is not specified, Java tries to locate the file based on the conventions.
       <tip>
       It is recommended that this system property be configured for Elasticsearch. The method for setting this property depends on your Kerberos infrastructure. Refer to your Kerberos documentation for more details.
       </tip>
       For more information, see [krb5.conf](https://web.mit.edu/kerberos/krb5-latest/doc/admin/conf_files/krb5_conf.html).
    2. Put the keytab file in the Elasticsearch configuration directory.
       Make sure that this keytab file has read permissions. This file contains credentials, therefore you must take appropriate measures to protect it.
       <important>
       Elasticsearch uses Kerberos on the HTTP network layer, therefore there must be a keytab file for the HTTP service principal on every Elasticsearch node. The service principal name must have the format `HTTP/es.domain.local@ES.DOMAIN.LOCAL`. The keytab files are unique for each node since they include the hostname. An Elasticsearch node can act as any principal a client requests as long as that principal and its credentials are found in the configured keytab.
       </important>
    3. Create a Kerberos realm.
       To enable Kerberos authentication in Elasticsearch, you must add a Kerberos realm in the realm chain.
       <note>
       You can configure only one Kerberos realm on Elasticsearch nodes.
       </note>
       To configure a Kerberos realm, there are a few mandatory realm settings and other optional settings that you need to configure in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file. Add a realm configuration under the `xpack.security.authc.realms.kerberos` namespace.
       The most common configuration for a Kerberos realm is as follows:
       ```yaml
       xpack.security.authc.realms.kerberos.kerb1:
        order: 3
        keytab.path: es.keytab
        remove_realm_name: false
       ```
    4. Restart Elasticsearch.
  </applies-item>

  <applies-item title="{ ess:, ece: }" applies-to="Elastic Cloud Hosted: Generally available, Elastic Cloud Enterprise: Generally available">
    1. Create a [custom bundle](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management) that contains your `krb5.conf` and `keytab` files, and add it to your cluster.
       <tip>
       You should use these exact filenames for Elastic Cloud to recognize the file in the bundle.
       </tip>
    2. Edit your cluster configuration, sometimes also referred to as the deployment plan, to define  your Kerberos settings:
       ```sh
       xpack.security.authc.realms.kerberos.cloud-krb:
          order: 2
          keytab.path: es.keytab
          remove_realm_name: false
       ```
       <important>
       The name of the realm must be `cloud-krb`, and the order must be 2: `xpack.security.authc.realms.kerberos.cloud-krb.order: 2`
       </important>
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    1. Install your `krb5.conf` and `keytab` files as a [custom configuration files](/docs/deploy-manage/deploy/cloud-on-k8s/custom-configuration-files-plugins#use-a-volume-and-volume-mount-together-with-a-configmap-or-secret). Mount them in a sub-directory of the main config directory, for example `/usr/share/elasticsearch/config/kerberos`, and use a `Secret` instead of a `ConfigMap` to store the information.
    2. Configure the JVM to find the Kerberos configuration file.
       Elasticsearch uses Java GSS and JAAS Krb5LoginModule to support Kerberos authentication using a Simple and Protected GSSAPI Negotiation (SPNEGO) mechanism. When the JVM needs some configuration properties, it tries to find those values by locating and loading the `krb5.conf` file. The JVM system property to configure the file path is `java.security.krb5.conf`. If this system property is not specified, Java tries to locate the file based on the conventions.
       To provide JVM setting overrides to your cluster:
       1. Create a new ConfigMap with a valid JVM options file as the key. The source file should be a JVM `.options` file containing the JVM system property `-Djava.security.krb5.conf=/usr/share/elasticsearch/config/kerberos/krb5.conf`, assuming the `krb5.conf` file was mounted on `/usr/share/elasticsearch/config/kerberos` in the previous step.
       ```
       # create a configmap with a key named override.options and the content of your local file
       kubectl create configmap jvm-options --from-file=override.options=<your-local-file>
       ```
       1. Reference the ConfigMap in your [cluster specification](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments):
       ```yaml
       apiVersion: elasticsearch.k8s.elastic.co/v1
       kind: Elasticsearch
       metadata:
       name: test-cluster
       spec:
       version: 8.17.0
       nodeSets:
       - name: default
           count: 3
           config:
           # this allows ES to run on nodes even if their vm.max_map_count has not been increased, at a performance cost
           node.store.allow_mmap: false
           podTemplate:
           spec:
               containers:
               - name: elasticsearch
                 volumeMounts:
                   - name: jvm-opts
                     mountPath: /usr/share/elasticsearch/config/jvm.options.d
                   - name: krb5
                     mountPath: /usr/share/elasticsearch/config/kerberos
              volumes:
              - name: jvm-opts
                configMap:
                  name: jvm-options
              - name: krb5
                secret:
                  name: kerberos-secret
       ```
    3. Edit your cluster configuration to define your Kerberos settings:
       ```yaml
       xpack.security.authc.realms.kerberos.cloud-krb:
          order: 2
          keytab.path: kerberos/keytab
          remove_realm_name: false
       ```
  </applies-item>
</applies-switch>

The `username` is extracted from the ticket presented by the user and usually has the format `username@REALM`. This `username` is used for mapping roles to the user. If realm setting `remove_realm_name` is set to `true`, the realm part (`@REALM`) is removed.

## Map Kerberos users to roles

The `kerberos` realm enables you to map Kerberos users to roles.
You can map these users to roles in multiple ways:
- Using the role mappings page in Kibana.
- Using the [role mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-put-role-mapping).

You identify users by their `username` field.
The following example uses the role mapping API to map `user@REALM` to the roles `monitoring` and `user`:
```json

{
  "roles" : [ "monitoring_user" ],
  "enabled": true,
  "rules" : {
    "field" : { "username" : "user@REALM" }
  }
}
```

In case you want to support Kerberos cross realm authentication, you may need to map roles based on the Kerberos realm name. For such scenarios, the following additional user metadata can be used for role mapping:
- `kerberos_realm`: The Kerberos realm name.
- `kerberos_user_principal_name`: The user principal name from the Kerberos ticket.

For more information, see [Mapping users and groups to roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles).
<note>
  The Kerberos realm supports [authorization realms](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/realm-chains#authorization_realms) as an alternative to role mapping.
</note>


## Use Kerberos authentication for Kibana

If you want to use Kerberos to authenticate using your browser and Kibana, you need to enable the relevant authentication provider in Kibana configuration. See [Kerberos single sign-on](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication#kerberos).