﻿---
title: Internal authentication
description: Internal authentication methods are fully managed by Elasticsearch, and don't require any communication with external parties. Elasticsearch offers two...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/internal-authentication
applies_to:
  - Elastic Stack: Generally available
---

# Internal authentication
Internal authentication methods are fully managed by Elasticsearch, and don't require any communication with external parties.
Elasticsearch offers two internal authentication [realms](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms), both of which are enabled by default. There can only be a maximum of one configured realm per internal realm type.
In this section, you'll learn how to configure internal realms, and manage users that authenticate using internal realms.

## Available internal realms

Elasticsearch provides two internal realm types:
<definitions>
  <definition term="native">
    Users are stored in a dedicated Elasticsearch index. This realm supports an authentication token in the form of username and password, and is available by default when no realms are explicitly configured. Users are managed through Kibana, or using [user management APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-security). See [Native user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native).
  </definition>
  <definition term="file">
    Users are defined in files stored on each node in the Elasticsearch cluster. This realm supports an authentication token in the form of username and password and is always available. See [File-based user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based). Available for Elastic Cloud on Kubernetes and self-managed deployments only.
  </definition>
</definitions>