﻿---
title: Granting privileges for data streams and aliases
description: Elasticsearch security features allow you to secure operations executed against data streams and aliases. Use index privileges to control access to a...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/granting-privileges-for-data-streams-aliases
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Granting privileges for data streams and aliases
Elasticsearch security features allow you to secure operations executed against [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams) and [aliases](https://www.elastic.co/docs/manage-data/data-store/aliases).

## Data stream privileges

Use [index privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices) to control access to a data stream. Granting privileges on a data stream grants the same privileges on its backing indices.
For example, `my-data-stream` consists of two backing indices: `.ds-my-data-stream-2099.03.07-000001` and `.ds-my-data-stream-2099.03.08-000002`.
A user is granted the `read` privilege to `my-data-stream`.
```js
{
  "names" : [ "my-data-stream" ],
  "privileges" : [ "read" ]
}
```

Because the user is automatically granted the same privileges to the stream’s backing indices, the user can retrieve a document directly from `.ds-my-data-stream-2099.03.08-000002`:
```json
```

Later `my-data-stream` [rolls over](/docs/manage-data/data-store/data-streams/use-data-stream#manually-roll-over-a-data-stream). This creates a new backing index: `.ds-my-data-stream-2099.03.09-000003`. Because the user still has the `read` privilege for `my-data-stream`, the user can retrieve documents directly from `.ds-my-data-stream-2099.03.09-000003`:
```json
```


## Alias privileges

Use [index privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices) to control access to an [alias](https://www.elastic.co/docs/manage-data/data-store/aliases). Privileges on an index or data stream do not grant privileges on its aliases. For information about managing aliases, see [*Aliases*](https://www.elastic.co/docs/manage-data/data-store/aliases).
<important>
  Don’t use [filtered aliases](/docs/manage-data/data-store/aliases#filter-alias) in place of [document level security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level). Elasticsearch doesn’t always apply alias filters.
</important>

For example, the `current_year` alias points only to the `2015` index. A user is granted the `read` privilege for the `2015` index.
```js
{
  "names" : [ "2015" ],
  "privileges" : [ "read" ]
}
```

When the user attempts to retrieve a document from the `current_year` alias, Elasticsearch rejects the request.
```json
```

To retrieve documents from `current_year`, the user must have the `read` index privilege for the alias.
```js
{
  "names" : [ "current_year" ],
  "privileges" : [ "read" ]
}
```