﻿---
title: External authentication
description: External authentication in Elastic is any form of authentication that requires interaction with parties and components external to Elasticsearch, typically...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/external-authentication
applies_to:
  - Elastic Stack: Generally available
---

# External authentication
External authentication in Elastic is any form of authentication that requires interaction with parties and components external to Elasticsearch, typically with enterprise grade identity management systems.
Elastic offers several external [realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms) types, each of which represents a common authentication provider. You can have as many external realms as you would like, each with its own unique name and configuration.
If the authentication provider that you want to use is not currently supported, then you can create your own [custom realm plugin](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/custom) to integrate with additional systems.
In this section, you'll learn how to configure different types of external realms, and use them to grant access to Elastic resources.
<tip>
  For many external realms, you need to perform extra steps to use the realm to log in to Kibana. [Learn more](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication).
</tip>


## Available external realms

Elasticsearch provides the following built-in external realms:
<definitions>
  <definition term="ldap">
    Uses an external LDAP server to authenticate the users. This realm supports an authentication token in the form of username and password, and requires explicit configuration in order to be used. LDAP is not available on Elastic Cloud Hosted deployments. For more information, refer to [LDAP user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap).
  </definition>
  <definition term="active_directory">
    Uses an external Active Directory Server to authenticate the users. With this realm, users are authenticated by usernames and passwords. Active Directory is not available on Elastic Cloud Hosted deployments. For more information, refer to [Active Directory user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/active-directory).
  </definition>
  <definition term="pki">
    Authenticates users using Public Key Infrastructure (PKI). This realm works in conjunction with SSL/TLS and identifies the users through the Distinguished Name (DN) of the client’s X.509 certificates. PKI is not available on Elastic Cloud Hosted deployments. For more information, refer to [PKI user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/pki).
  </definition>
  <definition term="saml">
    Facilitates authentication using the SAML 2.0 Web SSO protocol. This realm is designed to support authentication through Kibana and is not intended for use in the REST API. For more information, refer to [SAML authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml).
  </definition>
  <definition term="kerberos">
    Authenticates a user using Kerberos authentication. Users are authenticated on the basis of Kerberos tickets. For more information, refer to [Kerberos authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kerberos).
  </definition>
  <definition term="oidc">
    Facilitates authentication using OpenID Connect. It enables Elasticsearch to serve as an OpenID Connect Relying Party (RP) and provide single sign-on (SSO) support in Kibana. For more information, refer to [Configuring single sign-on to the Elastic Stack using OpenID Connect](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect).
  </definition>
  <definition term="jwt">
    Facilitates using JWT identity tokens as authentication bearer tokens. Compatible tokens are OpenID Connect ID Tokens, or custom JWTs containing the same claims. For more information, refer to [JWT authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/jwt).
  </definition>
</definitions>