﻿---
title: Built-in users in self-managed clusters
description: The Elastic Stack security features provide built-in user credentials to help you get up and running. These users have a fixed set of privileges and cannot...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Built-in users in self-managed clusters
The Elastic Stack security features provide built-in user credentials to help you get up and running. These users have a fixed set of privileges and cannot be authenticated until their passwords have been set. The `elastic` user can be used to [set all of the built-in user passwords](#set-built-in-user-passwords).
In orchestrated deployments (ECH, ECE, and ECK), the `elastic` user is managed by the platform, while other default users are not accessible to end users. To learn how to reset the `elastic` user in an Elastic Cloud Hosted, Elastic Cloud Enterprise, or Elastic Cloud on Kubernetes environment, refer to [Orchestrator-managed users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/orchestrator-managed-users-overview).
<admonition title="Create users with minimum privileges">
  The built-in users serve specific purposes and are not intended for general use. In particular, do not use the `elastic` superuser unless full access to the cluster is absolutely required. On self-managed deployments, use the `elastic` user to create users that have the minimum necessary roles or privileges for their activities.
</admonition>

<note>
  On Elastic Cloud, [operator privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-privileges) are enabled. These privileges restrict some infrastructure functionality, even if a role would otherwise permit a user to complete an administrative task.
</note>


## Built-in users

The following built-in users are available:
<definitions>
  <definition term="elastic">
    A built-in [superuser](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-superuser).
    Anyone who can log in as the `elastic` user has direct read-only access to restricted indices, such as `.security`. This user also has the ability to manage security and create roles with unlimited privileges.
  </definition>
  <definition term="kibana_system">
    The user Kibana uses to connect and communicate with Elasticsearch.
  </definition>
  <definition term="logstash_system">
    The user Logstash uses when storing monitoring information in Elasticsearch.
  </definition>
  <definition term="beats_system">
    The user the Beats use when storing monitoring information in Elasticsearch.
  </definition>
  <definition term="apm_system">
    The user the APM server uses when storing monitoring information in Elasticsearch.
  </definition>
  <definition term="remote_monitoring_user">
    The user Metricbeat uses when collecting and storing monitoring information in Elasticsearch. It has the `remote_monitoring_agent` and `remote_monitoring_collector` built-in roles.
  </definition>
</definitions>


## How the built-in users work

These built-in users are stored in a special `.security` index, which is managed by Elasticsearch. If a built-in user is disabled or its password changes, the change is automatically reflected on each node in the cluster. If your `.security` index is deleted or restored from a snapshot, however, any changes you have applied are lost.
Although they share the same API, the built-in users are separate and distinct from users managed by the [native realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native). Disabling the native realm will not have any effect on the built-in users. The built-in users can be disabled individually, using the [disable users API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-disable-user).

## The Elastic bootstrap password

<applies-to>
  - Self-managed Elastic deployments: Generally available
</applies-to>

<tip>
  Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes manage the `elastic` user differently. [Learn more](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/orchestrator-managed-users-overview).
</tip>

When you install Elasticsearch, if the `elastic` user does not already have a password, it uses a default bootstrap password. The bootstrap password is a transient password that enables you to run the tools that set all the built-in user passwords.
By default, the bootstrap password is derived from a randomized `keystore.seed` setting, which is added to the keystore during installation. You do not need to know or change this bootstrap password. If you have defined a `bootstrap.password` setting in the keystore, however, that value is used instead. For more information about interacting with the keystore, see [Secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings).
<note>
  After you [set passwords for the built-in users](#set-built-in-user-passwords), in particular for the `elastic` user, there is no further use for the bootstrap password.
</note>


## Setting initial built-in user passwords

<applies-to>
  - Self-managed Elastic deployments: Generally available
</applies-to>

You must set the passwords for all built-in users. You can set or reset passwords using several methods.
- Using `elasticsearch-setup-passwords`
- Using Kibana user management
- Using the change password API

If you want to reset built-in user passwords after initial setup, refer to [Set passwords for native and built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm).
<tip>
  Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes manage the `elastic` user differently. [Learn more](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/orchestrator-managed-users-overview).
</tip>


### Using `elasticsearch-setup-passwords`

The `elasticsearch-setup-passwords` tool is the simplest method to set the built-in users' passwords for the first time. It uses the `elastic` user’s bootstrap password to run user management API requests. For example, you can run the command in an "interactive" mode, which prompts you to enter new passwords for the `elastic`, `kibana_system`, `logstash_system`, `beats_system`, `apm_system`, and `remote_monitoring_user` users:
```shell
bin/elasticsearch-setup-passwords interactive
```

For more information about the command options, see [elasticsearch-setup-passwords](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/setup-passwords).
<important>
  After you set a password for the `elastic` user, the bootstrap password is no longer valid; you cannot run the `elasticsearch-setup-passwords` command a second time.
</important>


### Using Kibana user management or the change password API

You can set the initial passwords for the built-in users by using the **Management > Users** page in Kibana or the [change password API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-change-password).
To use these methods, you must supply the `elastic` user and its bootstrap password to log in to Kibana or run the API. This requirement means that you can't use the default bootstrap password that is derived from the `keystore.seed` setting. Instead, you must explicitly set a `bootstrap.password` setting in the keystore before you start Elasticsearch. For example, the following command prompts you to enter a new bootstrap password:
```shell
bin/elasticsearch-keystore add "bootstrap.password"
```

You can then start Elasticsearch and Kibana and use the `elastic` user and bootstrap password to log in to Kibana and change the passwords.

### Using the Change Password API

Alternatively, you can submit Change Password API requests for each built-in user. These methods are better suited for changing your passwords after the initial setup is complete, since at that point the bootstrap password is no longer required.

## Adding built-in user passwords to Kibana

After the `kibana_system` user password is set, you need to update the Kibana server with the new password by setting `elasticsearch.password` in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file:
```yaml
elasticsearch.password: kibanapassword
```

See [Configuring security in Kibana](https://www.elastic.co/docs/deploy-manage/security).

## Adding built-in user passwords to Logstash

The `logstash_system` user is used internally within Logstash when monitoring is enabled for Logstash.
To enable this feature in Logstash, you need to update the Logstash configuration with the new password by setting `xpack.monitoring.elasticsearch.password` in the `logstash.yml` configuration file:
```yaml
xpack.monitoring.elasticsearch.password: logstashpassword
```

If you have upgraded from an older version of Elasticsearch, the `logstash_system` user may have defaulted to *disabled* for security reasons. Once the password has been changed, you can enable the user via the following API call:
```json
```

See [Configuring credentials for Logstash monitoring](https://www.elastic.co/docs/reference/logstash/secure-connection#ls-monitoring-user).

## Adding built-in user passwords to Beats

The `beats_system` user is used internally within Beats when monitoring is enabled for Beats.
To enable this feature in Beats, you need to update the configuration for each of your beats to reference the correct username and password. For example:
```yaml
xpack.monitoring.elasticsearch.username: beats_system
xpack.monitoring.elasticsearch.password: beatspassword
```

For example, see [Monitoring Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/monitoring).
The `remote_monitoring_user` is used when Metricbeat collects and stores monitoring data for the Elastic Stack. See [*Monitoring in a production environment*](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed).
If you have upgraded from an older version of Elasticsearch, then you may not have set a password for the `beats_system` or `remote_monitoring_user` users. If this is the case, then you should use the **Management > Users** page in Kibana or the [change password API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-change-password) to set a password for these users.

## Adding built-in user passwords to APM

The `apm_system` user is used internally within APM when monitoring is enabled.
To enable this feature in APM, you need to update the `apm-server.yml` configuration file to reference the correct username and password. For example:
```yaml
xpack.monitoring.elasticsearch.username: apm_system
xpack.monitoring.elasticsearch.password: apmserverpassword
```

If you have upgraded from an older version of Elasticsearch, then you may not have set a password for the `apm_system` user. If this is the case, then you should use the **Management > Users** page in Kibana or the [change password API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-change-password) to set a password for these users.

## Disabling default password functionality

<important>
  This setting is deprecated. The elastic user no longer has a default password. The password must be set before the user can be used. See [The Elastic bootstrap password](#bootstrap-elastic-passwords).
</important>