﻿---
title: Set passwords for native and built-in users in self-managed clusters
description: After you implement security, you might need or want to change passwords for different users. If you want to reset a password for a built-in user such...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Set passwords for native and built-in users in self-managed clusters
After you implement security, you might need or want to change passwords for different users. If you want to reset a password for a [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users) such as the `elastic` or `kibana_system` users, or a user in the [native realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users), you can use the following tools:
- The **Manage users** UI in Kibana
- The [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool
- The [change passwords API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-change-password)

<tip>
  This topic describes resetting passwords after the initial bootstrap password is reset. To learn about the users that are used to communicate between Elastic Stack components, and about managing bootstrap passwords for built-in users, refer to [Built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
</tip>


## Using Kibana

Elastic enables you to easily manage users in Kibana from the **Users** page. From this page, you can create users, edit users, assign roles to users, and change user passwords. You can also deactivate or delete existing users.
You can access the **Users** management page in the navigation menu or find it using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).

## Using `elasticsearch-reset-password`

For example, the following command changes the password for a user with the username `user1` to an auto-generated value, and prints the new password to the terminal:
```shell
bin/elasticsearch-reset-password -u user1
```

To explicitly set a password for a user, include the `-i` parameter with the intended password.
```shell
bin/elasticsearch-reset-password -u user1 -i <password>
```

If you’re working in Kibana or don’t have command-line access, you can use the change passwords API to change a user’s password:
```json

{
  "password" : "new-test-password"
}
```


## Using the `user` API

You can manage users through the Elasticsearch `user` API.
For example, you can change a user's password:
```json

{
  "password" : "new-test-password"
}
```

For more information and examples, see [Users](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-security).